<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-03-20
 * Modified    : 2006-11-27
 * For LOVD    : 2.0-dev-34
 *
 * Access      : Public
 * Purpose     : Declare standard LOVD functions that are needed to build lists.
 *
 * Copyright   : 2004-2006 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

function lovd_pagesplitInit ($n_total, $n_limit = 100)
{
    // Function kindly provided by Ileos.nl in the interest of Open Source.
    // Initializes page splitting function which converts long lists of results
    // to a set number of results per page. Navigation code is included.
    // The Init function returns $s_query_limit, a string with the limit
    // information you need to include in your query.

    if (isset($_GET['page']) && is_numeric($_GET['page'])) {
        $n_current_page = $_GET['page'];
    } else {
        $n_current_page = 1;
    }

    if (!$n_total) {
        lovd_displayError('MySQL:Error|LibList', 'Could not initialize PageSplit. Missing argument $n_total.');
    }

    if (!is_numeric($n_total)) {
        lovd_displayError('MySQL:Error|LibList', 'Could not initialize PageSplit. Error in first argument (needs to be numeric).');
    }

    if (!is_numeric($n_limit)) {
        lovd_displayError('MySQL:Error|LibList', 'Could not initialize PageSplit. Error in second argument (needs to be numeric).');
    }

    global $_PAGESPLIT;
    if (isset($_PAGESPLIT)) {
        lovd_displayError('MySQL:Error|LibList', 'Could not initialize PageSplit. Needed variable $_PAGESPLIT exists!');
    }

    // No negative page numbers, please.
    if ($n_current_page < 1) {
        $n_current_page = 1;
    }

    $_PAGESPLIT = array(
                        'n_total' => $n_total,
                        'n_limit' => $n_limit,
                        'n_current_page' => $n_current_page,
                       );

    $_PAGESPLIT['n_limit_start'] = ($_PAGESPLIT['n_current_page'] - 1) * $_PAGESPLIT['n_limit'];
    $_PAGESPLIT['n_first_entry'] = $_PAGESPLIT['n_limit_start'] + 1;

    return 'LIMIT ' . $_PAGESPLIT['n_limit_start'] . ', ' . $_PAGESPLIT['n_limit'];
}





function lovd_pagesplitShowNav ($s_pagelink = '', $n_shown_pages = 5)
{
    // Function kindly provided by Ileos.nl in the interest of Open Source.
    // Initializes page splitting function which converts long lists of results
    // to a set number of results per page. Navigation code is included.
    // The ShowNav function writes PageSplit navigation to stdout.

    if (!is_numeric($n_shown_pages)) {
        die("Could not show PageSplit navigation. Error in second argument (needs to be numeric).");
    }

    // Get me my vars back!
    global $_PAGESPLIT;
    foreach ($_PAGESPLIT as $key => $val) {
        ${$key} = $val;
    }

    print('      <SPAN class="S11">' . "\n");

    // Standaard $_GET variabelen die altijd mee moeten.
    $aGET = array('action', 'limit');
    $sTMP = '';
    foreach ($aGET as $val) {
        if (isset($_GET[$val])) {
            $sTMP .= ($sTMP? '&amp;' : '') . $val . '=' . $_GET[$val];
        }
    }
    $s_pagelink = $sTMP . ($sTMP && $s_pagelink? '&amp;' : '') . $s_pagelink;

    // Laatste entry van de pagina.
    $n_last_entry = $n_current_page * $n_limit;
    if ($n_last_entry > $n_total) {
        $n_last_entry = $n_total;
    }

    // Print entry (range) die je nu bekijkt.
    if ($n_first_entry == $n_last_entry) {
        print('      ' . $n_first_entry . '<BR>' . "\n");
    } elseif ($n_first_entry <= $n_total) {
        print('      ' . $n_first_entry . ' - ' . $n_last_entry . "\n");
    }

    if ($n_total > $n_limit) {
        // Navigatie erbij.
        print('      <BR>' . "\n");

        // Eerste geprint paginanummer.
        $n_page_printing = $n_current_page - $n_shown_pages;
        if ($n_page_printing < 1) {
            $n_page_printing = 1;
        }

        if ($s_pagelink && substr($s_pagelink, -1) != '&' && substr($s_pagelink, -5) != '&amp;') {
            $s_pagelink .= '&amp;';
        }

        // Totaal aantal pagina's benodigd voor alle hits.
        $n_total_pages = ceil($n_total / $n_limit);

        // Als er pagina's wegvallen, geef dan links de 'eerste pagina' tekst / link.
        if ($n_page_printing > 1) {
            print('      [<A href="' . $_SERVER['PHP_SELF'] . '?' . $s_pagelink . 'page=1">&lt;&lt;</A>] ');
        } elseif ($n_total_pages > (2 * $n_shown_pages) + 1) {
            print('      [&lt;&lt;] ');
        }

        // 'Vorige' tekst / link.
        if ($n_current_page > 1) {
            $n_previous_page = $n_current_page - 1;
            print(' [<A href="' . $_SERVER['PHP_SELF'] . '?' . $s_pagelink . 'page=' . $n_previous_page . '">&lt;-</A>] ');
        } else {
            print(' [&lt;-] ');
        }

        // Weggevallen pagina's.
        if ($n_page_printing > 1) {
            print(' ... ');
        }

        // Loop door alle, te printen, pagina's.
        for ($i = $n_page_printing; $i <= $n_total_pages && $i <= ($n_current_page + $n_shown_pages); $i ++) {
            if ($n_current_page == $i) {
                print(' <B>' . $i . '</B> ');
            } else {
                print(' <A href="' . $_SERVER['PHP_SELF'] . '?' . $s_pagelink . 'page=' . $i . '">' . $i . '</A> ');
            }
        }

        // Laatste, geprinte, pagina.
        $n_page_printing = $i - 1;

        // Pagina's weggevallen.
        if ($n_page_printing != $n_total_pages) {
            print(' ... ');
        }

        // 'Volgende' tekst / link.
        if (($n_limit * $n_current_page) < $n_total) {
            $n_next_page = $n_current_page + 1;
            print(' [<A href="' . $_SERVER['PHP_SELF'] . '?' . $s_pagelink . 'page=' . $n_next_page . '">-&gt;</A>]');
        } else {
            print(' [-&gt;]');
        }

        // Als er pagina's wegvallen, geef dan rechts de 'laatste pagina' tekst / link.
        if ($n_page_printing != $n_total_pages) {
            print('  [<A href="' . $_SERVER['PHP_SELF'] . '?' . $s_pagelink . 'page=' . $n_total_pages .'">&gt;&gt;</A>]' . "\n");
        } elseif ($n_total_pages > (2 * $n_shown_pages) + 1) {
            print('  [&gt;&gt;]' . "\n");
        }
    }

    print('      </SPAN><BR>' . "\n" .
          '      <BR>' . "\n\n");
}
?>