<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-04-20
 * Modified    : 2007-09-03
 * For LOVD    : 2.0-beta-08
 *
 * Access      : Administrator and managers
 * Purpose     : Provide links to setup actions to managers and the database
 *               administrator.
 *
 * Copyright   : 2004-2007 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

require ROOT_PATH . 'inc-top.php';
lovd_printHeader('setup', 'LOVD Setup');

// Require manager clearance.
lovd_requireAUTH(LEVEL_MANAGER);





// Some info & statistics.
list($nUsers) = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_USERS));
list($nSubs)  = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_SUBS));
list($nLogs)  = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_LOGS));
$aTotalVars   = array();
$nTotalVars   = 0;
$q = mysql_query('SELECT COUNT(*), status FROM ' . TABLE_PAT2VAR . ' GROUP BY status ORDER BY status');
while ($r = mysql_fetch_row($q)) {
    $aTotalVars[$r[1]] = $r[0];
    $nTotalVars += $r[0];
}

print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Leiden Open Variation Database</B></TD>' . "\n" .
      '                <TD colspan="4"><B>Statistics</B></TD>' . "\n" .
      '                <TD colspan="' . (count($aTotalVars) + 1) . '"><B>Variants</B></TD></TR>' . "\n" .
      '              <TR class="S11">' . "\n" .
      '                <TD>Installed:' . $_STAT['date_install'] . '</TD>' . "\n" .
      '                <TD>Updated:' . ($_STAT['date_updated']? $_STAT['date_updated'] : '-') . '</TD>' . "\n" .
      '                <TD>Users:' . $nUsers . '</TD>' . "\n" .
      '                <TD>Submitters:' . $nSubs . '</TD>' . "\n" .
      '                <TD>Genes:' . GENE_COUNT . '</TD>' . "\n" .
      '                <TD>Log entries:' . $nLogs . '</TD>' . "\n" .
      '                <TD>Total:' . $nTotalVars . '</TD>');
foreach ($aTotalVars as $nStatus => $nVars) {
    print("\n" .
          '                <TD>' . $_SETT['var_status'][$nStatus] . ':' . $nVars . '</TD>');
}
print('</TR></TABLE><BR>' . "\n\n");



// Setup main table.
print('      <TABLE border="0" cellpadding="0" cellspacing="0" width="100%">' . "\n" .
      '        <TR>' . "\n" .
      '          <TD valign="top" width="50%" style="padding-right : 10px; border-right : 1px solid #224488;">' . "\n");

// LOVD settings and uninstall.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>General LOVD Setup</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_settings.php' . lovd_showSID() . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_settings.png" alt="LOVD System settings" width="32" height="32"></TD>' . "\n" .
      '                <TD>View and change LOVD System settings, including settings on statistics, security and the legend.</TD></TR>' .
      ($_CONF['lock_uninstall'] || $_AUTH['level'] < LEVEL_ADMIN? '' :
      "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'install/uninstall.php' . lovd_showSID() . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_warning.png" alt="Uninstall LOVD" width="32" height="32"></TD>' . "\n" .
      '                <TD>Uninstall LOVD.</TD></TR>') .
      '</TABLE><BR>' . "\n");

// Custom columns.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Custom columns</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_columns.php?action=add' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_columns_add.png" alt="Add pre-configured custom patient column" width="32" height="32"></TD>' . "\n" .
      '                <TD>Add pre-configured custom patient column.</TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_columns.php?action=view_all' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_columns_edit.png" alt="Manage custom patient columns" width="32" height="32"></TD>' . "\n" .
      '                <TD>Manage custom patient columns.</TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_columns_global.php?action=create' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_columns_create.png" alt="Create new custom column" width="32" height="32"></TD>' . "\n" .
      '                <TD>Create new custom column.</TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_columns_global.php?action=view_all' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_columns_view.png" alt="View all custom columns" width="32" height="32"></TD>' . "\n" .
      '                <TD>View all custom columns.</TD></TR></TABLE><BR>' . "\n");

// Custom links.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Custom links</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_links.php?action=create' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_links_create.png" alt="Create new custom link" width="32" height="32"></TD>' . "\n" .
      '                <TD>Create a new custom link.</TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_links.php?action=view_all' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_links_edit.png" alt="Manage custom links" width="32" height="32"></TD>' . "\n" .
      '                <TD>Manage custom links.</TD></TR></TABLE><BR>' . "\n");

// Modules.
list($nModules) = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_MODULES));
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Modules</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_modules.php?action=scan' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_modules_scan.png" alt="Scan for new modules" width="32" height="32"></TD>' . "\n" .
      '                <TD>Scan LOVD install directory for new modules.</TD></TR>' .
      (!$nModules? '' :
      "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_modules.php?action=view_all' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_modules_manage.png" alt="Manage modules" width="32" height="32"></TD>' . "\n" .
      '                <TD>Manage installed LOVD modules.</TD></TR>') .
      '</TABLE>' . "\n");



print('          </TD>' . "\n" .
      '          <TD valign="top" width="50%" style="padding-left : 10px;">' . "\n");



// Gene databases.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Gene databases</B></TD></TR>' . "\n" .
      '              <TR class="setup" id="create_gene" onclick="window.location.href=\'' . ROOT_PATH . 'setup_genes.php?action=create' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_database_create.png" alt="Create new gene database" width="32" height="32"></TD>' . "\n" .
      '                <TD>Create a new gene database.</TD></TR>' .
      (!GENE_COUNT? '' :
      "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_genes.php?action=view_all' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_database_edit.png" alt="Manage gene databases" width="32" height="32"></TD>' . "\n" .
      '                <TD>Manage configured gene databases.</TD></TR>') .
      '</TABLE><BR>' . "\n");

// Users.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Authorized users</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_users.php?action=create' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_users_create.png" alt="Create new user" width="32" height="32"></TD>' . "\n" .
      '                <TD>Create a new authorized user.</TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_users.php?action=view_all' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_users_edit.png" alt="Manage users" width="32" height="32"></TD>' . "\n" .
      '                <TD>Manage authorized users.</TD></TR></TABLE><BR>' . "\n");

// Submitters.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Submitters</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_submitters.php?action=create' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_submitters_create.png" alt="Create new submitter" width="32" height="32"></TD>' . "\n" .
      '                <TD>Create a submitter.</TD></TR>' .
      (!$nSubs? '' :
      "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_submitters.php?action=view_all' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_submitters_edit.png" alt="Manage submitters" width="32" height="32"></TD>' . "\n" .
      '                <TD>Manage submitters.</TD></TR>') .
      '</TABLE><BR>' . "\n");

// System logs.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>System logs</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'setup_logs.php?action=select' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_logs.png" alt="System logs" width="32" height="32"></TD>' . "\n" .
      '                <TD>View, search and delete system logs.</TD></TR></TABLE>' . "\n");



print('          </TD>' . "\n" .
      '        </TR>' . "\n" .
      '      </TABLE>' . "\n");



// Newly installed? Flash create gene link.
if (isset($_GET['newly_installed'])) {
    print('      <SCRIPT type="text/javascript">' . "\n" .
          '        <!--' . "\n" .
          '        varTR = document.getElementById(\'create_gene\');' . "\n");
    for ($i = 0; $i < 30; $i ++) {
        print('        setTimeout("varTR.style.background=\'#' . ($i%2? 'F0F3FF' : 'C8DCFA') . '\'", ' . ($i * 1000) . ');' . "\n");
    }
    print('        setTimeout("varTR.style.background=\'\'", ' . ($i * 1000) . ');' . "\n");
    print('        // -->' . "\n" .
          '      </SCRIPT>' . "\n\n");
}

require ROOT_PATH . 'inc-bot.php';
?>