<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-11-01
 * Modified    : 2006-11-27
 * For LOVD    : 2.0-dev-34
 *
 * Access      : Public
 * Purpose     : Generate overview of database content. Summary per gene
 *               and total numbers.
 *
 * Copyright   : 2004-2006 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// Provide gene homepage.
require ROOT_PATH . 'inc-top.php';
lovd_printHeader('status', 'LOVD - Current system status');

print('      ' . date('Y/m/d H:i:s T \- l, F jS Y') . '<BR><BR>' . "\n\n");

$nTotal = 0;
$nUnique = 0;
$q = mysql_query('SELECT symbol, gene FROM ' . TABLE_DBS . ' ORDER BY symbol');
$nGenes = mysql_num_rows($q);










///////////////////////////////////////////////////////////////////////////////*

// Loop per gene; curated entries only.
while ($z = mysql_fetch_assoc($q)) {
    list($nTotalVariants)  = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_PAT2VAR . ' WHERE symbol = "' . $z['symbol'] . '" AND status >= ' . STATUS_MARKED));
    list($nUniqueVariants) = mysql_fetch_row(mysql_query('SELECT COUNT(DISTINCT v.`Variant/DNA`) FROM ' . TABLE_PAT2VAR . ' AS p2v LEFT JOIN ' . TABLEPREFIX . '_' . $z['symbol'] . '_variants AS v USING (variantid) WHERE p2v.symbol = "' . $z['symbol'] . '" AND p2v.status >= ' . STATUS_MARKED));
    $nTotal += $nTotalVariants;
    $nUnique += $nUniqueVariants;
    print('      <B>' . $z['symbol'] . ' (' . $z['gene'] . ')</B><BR>' . "\n" .
          '      <B>Total :</B> ' . $nTotalVariants . '<BR>' . "\n" .
          '      <B>Unique :</B> ' . $nUniqueVariants . '<BR><BR>' . "\n\n");
}

// Total cumulative numbers.
print('      <B>Total of ' . $nGenes . ' gene entr' . ($nGenes == 1? 'y' : 'ies') . '</B><BR>' . "\n" .
      '      <B>Total variant entries :</B> ' . $nTotal . '<BR>' . "\n" .
      '      <B>Total unique variant entries :</B> ' . $nUnique . '<BR><BR>' . "\n\n");

require ROOT_PATH . 'inc-bot.php';
?>