<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-11-21
 * Modified    : 2007-09-05
 * For LOVD    : 2.0-beta-08
 *
 * Access      : Public
 * Purpose     : Edit & drop patients.
 *
 * Copyright   : 2004-2007 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// Require curator clearance.
lovd_requireAUTH(LEVEL_CURATOR);

// If curator, the patient can't have any variants associated with genes not curated by the curator.
if ($_GET['action'] == 'edit') {
    $_GET['patientid'] = $_GET['edit'];
} elseif ($_GET['action'] == 'drop') {
    $_GET['patientid'] = $_GET['drop'];
}

// Check if user is allowed to edit patients.
if (empty($_GET['patientid'])) {
    $bEditable = false;
} elseif ($_AUTH['level'] < LEVEL_MANAGER) {
    if (!empty($_AUTH['curates'])) {
        $bEditable = !mysql_num_rows(mysql_query('SELECT symbol FROM ' . TABLE_PAT2VAR . ' WHERE patientid = "' . $_GET['patientid'] . '" AND symbol NOT IN ("' . implode('", "', $_AUTH['curates']) . '") GROUP BY symbol'));
    } else {
        $bEditable = false;
    }
} else {
    $bEditable = true;
}

if (!$bEditable) {
    require ROOT_PATH . 'inc-top.php';
    lovd_showInfoTable('You are not allowed access to this patient, because the patient has sequence variants from genes you do not control.', 'stop');
    require ROOT_PATH . 'inc-bot.php';
    exit;
}





if ($_GET['action'] == 'edit' && is_numeric($_GET['patientid'])) {
    // Edit specific patient.

    $zData = @mysql_fetch_assoc(mysql_query('SELECT p.* FROM ' . TABLE_PATIENTS . ' AS p WHERE p.patientid = "' . $_GET['patientid'] . '"'));
    if (!$zData) {
        // Wrong ID, apparently.
        require ROOT_PATH . 'inc-top.php';
        lovd_printHeader('patients_manage', 'LOVD Manage patients');
        lovd_showInfoTable('No such ID!', 'stop');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';
    require ROOT_PATH . 'class/currdb.php';
    $_CURRDB = new CurrDB();

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Mandatory fields.
        $_CURRDB->checkMandatory('Patient');

        // Field lengths.
        $_CURRDB->checkInputLength();

        // Field types.
        $_CURRDB->checkInputType();

        // Regular expressions.
        $_CURRDB->checkInputRegExp();

        // Mandatory fields.
        $aCheck =
                 array(
                        'password' => 'Enter your password for authorization',
                      );

        foreach ($aCheck as $key => $val) {
            if (!$_POST[$key]) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        // Other checks ...
        // User had to enter his/her password for authorization.
        if ($_POST['password'] && md5($_POST['password']) != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        }

        // 2006-12-07; 2.0-alpha-02
        // XSS attack prevention. Simply deny input of HTML, PHP other stuff blocked by strip_tags().
        lovd_checkXSS();

        if (!lovd_error()) {
            // Query text.
            $sQ = 'UPDATE ' . TABLE_PATIENTS . ' SET ';

            // Get columns to update in the database.
            $aCols = $_CURRDB->getColList('Patient');
            foreach ($aCols as $key => $val) {
                // 2007-06-28; 2.0-beta-05; sometimes fields are not sent. HTTP posting faked or empty selection list?
                if (!isset($_POST[$val])) {
                    $_POST[$val] = '';
                }

                // Selection list to value.
                if (is_array($_POST[$val])) {
                    $_POST[$val] = implode(';', $_POST[$val]);
                }
                $sQ .= ($key? ', ' : '') . '`' . $val . '` = "' . $_POST[$val] . '"';
            }

            $sQ .= ', edited_by = "' . $_AUTH['userid'] . '", edited_date = NOW() WHERE patientid = "' . $_GET['patientid'] . '"';

            $q = mysql_query($sQ);
            if (!$q) {
                require ROOT_PATH . 'inc-top.php';
                lovd_printHeader('patients_manage', 'LOVD Manage patients');
                lovd_dbFout('PatientEdit', $sQ, mysql_error());
            }

            // Write to log...
            lovd_writeLog('MySQL:Event', 'PatientEdit', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully edited patient #' . $zData['patientid']);

            // Thank the user...
            // 2007-08-09; 2.0-beta-07; View patient information without considering any variants is now possible.
 //            header('Refresh: 3; url=http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/variants.php?action=view_all' . lovd_showSID(true));
            header('Refresh: 3; url=http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/variants.php?select_db=' . $_SESSION['currdb'] . '&action=view&view=' . $zData['patientid'] . lovd_showSID(true));

            require ROOT_PATH . 'inc-top.php';
            lovd_printHeader('patients_manage', 'LOVD Manage patients');
            lovd_showInfoTable('Successfully edited patient!', 'success');

            require ROOT_PATH . 'inc-bot.php';
            exit;

        } else {
            // Errors, so the whole lot returns to the form.
            lovd_magicUnquote();

            // Because we're sending the data back to the form, I need to unset the password fields!
            unset($_POST['password']);
        }

    } else {
        foreach ($zData as $key => $val) {
            if (!isset($_POST[$key]) || !$_POST[$key]) {
                $_POST[$key] = $val;
            }
        }
        // Transform select lists' values.
        $_CURRDB->transformSelectValues($_POST, true);
        $_POST['password'] = '';
    }



    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('patients_manage', 'LOVD Manage patients');

    if (!isset($_GET['sent'])) {
        print('      To edit the patient data, please fill out the form below.<BR>' . "\n" .
              '      <BR>' . "\n\n");
    }

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '&amp;edit=' . $_GET['edit'] . '&amp;sent=true" method="post">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Array which will make up the form table.
    $aForm = array_merge(
                         array(
                                array('POST', '', '', '40%', '60%'),
                              ),
                         $_CURRDB->buildFormTable('Patient'),
                         array(
                                'skip',
                                array('Enter your password for authorization', 'password', 'password', 20),
                                array('', 'submit', 'Edit patient data'),
                              ));
    $_MODULES->processForm('SubmitPatientsEdit', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} elseif ($_GET['action'] == 'drop' && is_numeric($_GET['patientid'])) {
    // Drop specific patient, including all of it's links.

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';
    require ROOT_PATH . 'class/currdb.php';
    $_CURRDB = new CurrDB();

    $zData = @mysql_fetch_assoc(mysql_query('SELECT p.* FROM ' . TABLE_PATIENTS . ' AS p WHERE p.patientid = "' . $_GET['patientid'] . '"'));
    if (!$zData) {
        // Wrong ID, apparently.
        require ROOT_PATH . 'inc-top.php';
        lovd_printHeader('patients_manage', 'LOVD Manage patients');
        lovd_showInfoTable('No such ID!', 'stop');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Mandatory fields.
        $aCheck =
                 array(
                        'password' => 'Enter your password for authorization',
                      );

        foreach ($aCheck as $key => $val) {
            if (!$_POST[$key]) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        // Other checks ...
        // User had to enter his/her password for authorization.
        if ($_POST['password'] && md5($_POST['password']) != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        }

        if (!lovd_error()) {
            // Drop Patient links, Remove orphaned patients from TABLE_PATIENTS and orphaned variants from TABLE_CURRDB_VARS.

            require ROOT_PATH . 'inc-top.php';
            lovd_printHeader('patients_manage', 'LOVD Manage patients');

            // If using transactional tables; begin transaction.
            if ($_INI['database']['engine'] == 'InnoDB') {
                // FIXME; It's better to use 'START TRANSACTION', but that's only available from 4.0.11.
                //   This works from the introduction of InnoDB in 3.23
                @mysql_query('BEGIN WORK');
            }

            // Start with the patient's connection.
            print('      Removing patient...<BR>' . "\n" .
                  '      Removing variant <-> patient link(s) ... ');
            flush();
            // Before we start deleting this stuff, I need this information for removing orphaned variants in other genes.
            $aGenes = array($_SESSION['currdb']);
            $sQ = 'SELECT DISTINCT symbol FROM ' . TABLE_PAT2VAR . ' WHERE patientid = "' . $_GET['patientid'] . '" AND symbol != "' . $_SESSION['currdb'] . '" ORDER BY symbol';
            $q = @mysql_query($sQ);
            if (!$q) {
                // OK, this failed, but we will continue. We've got the current gene anyway.
                lovd_dbFout('PatientDropFindGenes', $sQ, mysql_error(), false);
            } else {
                while ($r = mysql_fetch_row($q)) {
                    $aGenes[] = $r[0];
                }
            }

            // Remove...
            $sQ = 'DELETE FROM ' . TABLE_PAT2VAR . ' WHERE patientid = "' . $_GET['patientid'] . '"';
            $q = mysql_query($sQ);
            if (!$q) {
                lovd_dbFout('PatientDropA', $sQ, mysql_error());
            }
            print('OK<BR>' . "\n");

            // Orphaned patients.
            print('      Removing obsolete patients ... ');
            flush();
            // Backwards compatible with MySQL 4.0 and earlier. These versions do not support subqueries, which would really come in handy now.
            // Fist, determine the ID's of the orphaned patients. Then construct the DELETE query.
            $aOrphaned = array();
            $qOrphaned = mysql_query('SELECT p.patientid FROM ' . TABLE_PATIENTS . ' AS p LEFT OUTER JOIN ' . TABLE_PAT2VAR . ' AS p2v USING (patientid) WHERE p2v.symbol IS NULL');
            while ($rOrphaned = mysql_fetch_row($qOrphaned)) {
                $aOrphaned[] = $rOrphaned[0];
            }
            if (count($aOrphaned)) {
                // Construct DELETE query.
                $sQ = 'DELETE FROM ' . TABLE_PATIENTS . ' WHERE patientid IN (' . implode(', ', $aOrphaned) . ')';
                $q = mysql_query($sQ);
                if (!$q) {
                    lovd_dbFout('PatientDropB', $sQ, mysql_error());
                }
                print('OK<BR>' . "\n");
            } else {
                print('N/A<BR>' . "\n");
            }

            // Orphaned variants (multiple genes).
            print('      Removing obsolete variants...<BR>' . "\n");
            flush();
            foreach ($aGenes as $sGene) {
                print('      &nbsp;&nbsp;&nbsp;&nbsp;From ' . $sGene . ' ... ');
                flush();
                // Backwards compatible with MySQL 4.0 and earlier. These versions do not support subqueries, which would really come in handy now.
                // Fist, determine the ID's of the orphaned patients. Then construct the DELETE query.
                $aOrphaned = array();
                $qOrphaned = mysql_query('SELECT v.variantid FROM ' . TABLE_CURRDB_VARS . ' AS v LEFT OUTER JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (v.variantid = p2v.variantid AND p2v.symbol = "' . $sGene . '") WHERE p2v.symbol IS NULL');
                while ($rOrphaned = mysql_fetch_row($qOrphaned)) {
                    $aOrphaned[] = $rOrphaned[0];
                }
                if (count($aOrphaned)) {
                    // Construct DELETE query.
                    $sQ = 'DELETE FROM ' . TABLEPREFIX . '_' . $sGene . '_variants WHERE variantid IN (' . implode(', ', $aOrphaned) . ')';
                    $q = mysql_query($sQ);
                    if (!$q) {
                        lovd_dbFout('PatientDropC', $sQ, mysql_error());
                    }
                    print('OK<BR>' . "\n");
                } else {
                    print('N/A<BR>' . "\n");
                }
            }
            print('      <BR>' . "\n\n");

            // If we don't do this, we haven't done anything in the DB... duh!
            if ($_INI['database']['engine'] == 'InnoDB') {
                // Could this actually fail?!!??
                @mysql_query('COMMIT');
            }

            // Write to log...
            lovd_writeLog('MySQL:Event', 'PatientDrop', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully deleted patient #' . $_GET['patientid']);

            // Thank the user...
            lovd_showInfoTable('Successfully deleted patient!', 'success');

            // Alternate refresh; since we can't send a HTTP header...
            print('      <SCRIPT type="text/javascript">' . "\n" .
                  '      <!--' . "\n" .
                  '        setTimeout(\'window.location.href = "http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/variants.php?action=view_all' . lovd_showSID(true, true) . '"\', 5000);' . "\n" .
                  '      // -->' . "\n" .
                  '      </SCRIPT>' . "\n\n");

            require ROOT_PATH . 'inc-bot.php';
            exit;

        } else {
            // Fouten, dus de zooi moet terug naar het formulier.
            lovd_magicUnquote();

            // Omdat het geheel terug gaat naar het formulier, moet ik de password fields wel weghalen!
            unset($_POST['password']);
        }
    }



    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('patients_manage', 'LOVD Manage patients');

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '&amp;drop=' . $_GET['drop'] . '&amp;sent=true" method="post">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Array which will make up the form table.
    $aForm = array(
                    array('POST', '', '', '50%', '50%'),
                    array('Deleting patient', 'print', ($zData['Patient/Patient_ID']? $zData['Patient/Patient_ID'] : '#' . $zData['patientid'])),
                    'skip',
                    array('Enter your password for authorization', 'password', 'password', 20),
                    array('', 'submit', 'Delete patient'),
                  );
    $_MODULES->processForm('SubmitPatientsDelete', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} elseif ($_GET['action'] == 'assign_submitter' && is_numeric($_GET['patientid'])) {
    // Assign submitter to this patient.

    $zData = @mysql_fetch_assoc(mysql_query('SELECT p.patientid, p.submitterid FROM ' . TABLE_PATIENTS . ' AS p WHERE p.patientid = "' . $_GET['patientid'] . '"'));
    if (!$zData) {
        // Wrong ID, apparently.
        require ROOT_PATH . 'inc-top-clean.php';
        lovd_showInfoTable('No such ID!', 'stop');
        require ROOT_PATH . 'inc-bot-clean.php';
        exit;
    }

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        if (!lovd_error()) {
            // Query text.
            $sQ = 'UPDATE ' . TABLE_PATIENTS . ' SET submitterid = "' . $_POST['submitterid'] . '" WHERE patientid = "' . $_GET['patientid'] . '"';

            $q = mysql_query($sQ);
            if (!$q) {
                require ROOT_PATH . 'inc-top-clean.php';
                lovd_dbFout('PatientEdit', $sQ, mysql_error());
            }

            // Write to log...
            lovd_writeLog('MySQL:Event', 'SubmitterAssign', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully ' . ($_POST['submitterid']? 'assigned submitter #' . $_POST['submitterid'] . ' to' : 'removed submitter association from') . ' patient #' . $zData['patientid']);

            // Thank the user...
            require ROOT_PATH . 'inc-top-clean.php';
            if ($_POST['submitterid']) {
                lovd_showInfoTable('Successfully assigned submitter #' . $_POST['submitterid'] . ' to patient!', 'success');
            } else {
                lovd_showInfoTable('Successfully cleared submitterid from patient!', 'success');
            }

            print('      <SCRIPT type="text/javascript">' . "\n" .
                  '        <!--' . "\n" .
                  '        opener.location.reload();' . "\n" .
                  '        setTimeout("self.close()", 1000);' . "\n" .
                  '        // -->' . "\n" .
                  '      </SCRIPT>' . "\n\n");

            require ROOT_PATH . 'inc-bot-clean.php';
            exit;

        } else {
            // Errors, so the whole lot returns to the form.
            lovd_magicUnquote();

            // Because we're sending the data back to the form, I need to unset the password fields!
            unset($_POST['password']);
        }

    } else {
        $_POST['submitterid'] = $zData['submitterid'];
        $_POST['password'] = '';
    }



    require ROOT_PATH . 'inc-top-clean.php';

    if (!isset($_GET['sent'])) {
        print('      Please select the submitter you wish to assign to this patient.<BR>' . "\n" .
              '      <BR>' . "\n\n");
    }

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '&amp;patientid=' . $zData['patientid'] . '&amp;sent=true" method="post">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="680">');

    $qSubmitters = mysql_query('SELECT s.submitterid, CONCAT(c.country, " / ", s.city, " - ", s.firstname, " ", s.lastname, " (#", s.submitterid, ")") AS name FROM ' . TABLE_SUBS . ' AS s LEFT JOIN ' . TABLE_COUNTRIES . ' AS c ON (s.country = c.code) ORDER BY name');

    // Array which will make up the form table.
    $aForm = array_merge(
                         array(
                                array('POST', '', '', '18%', '82%'),
                                array('Submitter', 'select', 'submitterid', 1, $qSubmitters, '-- None --', false, false),
                                'skip',
                                array('', 'submit', 'Assign submitter'),
                              ));
    $_MODULES->processForm('SubmitPatientsEdit', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot-clean.php';
    exit;





} else {
    // Default action:
    header('Location: http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/variants.php?action=view_all' . lovd_showSID(true));
    exit;
}
?>