<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2007-06-28
 * Modified    : 2008-01-29
 * For LOVD    : 2.0-04
 *
 * Access      : Public
 * Purpose     : Allow overview of all variants in all genes based on a search
 *               on the Patient/Origin/* fields.
 *
 * Copyright   : 2004-2008 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

require ROOT_PATH . 'inc-top.php';
require ROOT_PATH . 'inc-lib-form.php';
require ROOT_PATH . 'class/currdb.php';
lovd_printHeader('variant_search', 'LOVD - Search variants');





// Do we even have the origin fields enabled?
// Sounds stupid, but I need a gene here...
if ($_SESSION['currdb']) {
    $_CURRDB = new CurrDB();
} elseif (!GENE_COUNT) {
    // Standard situation.
    $_CURRDB = new CurrDB(false);
} else {
    // Fetch a gene. Any gene!
    list($sSymbol) = mysql_fetch_row(mysql_query('SELECT symbol FROM ' . TABLE_DBS . ' LIMIT 1'));
    $_CURRDB = new CurrDB(false, $sSymbol);
}

// Hide public columns for all curators.
// FIXME; Actually, a curator who owns every single gene should be included... Hmm...
$_CURRDB->hideCols('public', ($_AUTH['level'] >= LEVEL_MANAGER));
$aColList = $_CURRDB->getColList();
$aOriginCols = array();
foreach ($aColList as $sCol) {
    if (substr($sCol, 0, 15) == 'Patient/Origin/') {
        $aOriginCols[] = $sCol;
    }
}

$nOriginCols = count($aOriginCols);
if (!$nOriginCols) {
    // No origin columns enabled... goodbye!
    lovd_showInfoTable('There are no Patient/Origin columns enabled. Therefor this overview is non functional.', 'stop');
    require ROOT_PATH . 'inc-bot.php';
    exit;
}





// Show form in all cases.
print('      Fill in at least one of the origin fields to search the gene databases.<BR>' . "\n" .
      '      <BR>' . "\n\n");

// Select current gene, at least.
if (empty($_GET['genes']) || !is_array($_GET['genes'])) {
    $_GET['genes'] = array();
    if ($_SESSION['currdb']) {
        $_GET['genes'][] = $_SESSION['currdb'];
    }
}

// Fetch genes.
$qGenes = mysql_query('SELECT symbol, gene FROM ' . TABLE_DBS . ' ORDER BY symbol');
$nGenes = mysql_num_rows($qGenes);

// Table.
print('      <FORM action="' . $_SERVER['PHP_SELF'] . '" method="get">' . "\n" .
      '        <INPUT type="hidden" name="order" value="' . (!empty($_GET['order'])? $_GET['order'] : '') . '">' . "\n" .
      '        <TABLE border="0" cellpadding="0" cellspacing="1" width="950">' . "\n" .
      '          <TR>' . "\n" .
      '            <TD valign="top" rowspan="' . ($nOriginCols + 3) . '" width="33%" style="padding-right : 10px;">' . "\n" .
      '              <B>Select gene(s) you wish to search in</B><BR>' . "\n" .
      '              <SELECT name="genes[]" size="' . ($nGenes > 5? 5 : $nGenes) . '" multiple>' . "\n");
while ($zGenes = mysql_fetch_assoc($qGenes)) {
    print('              <OPTION value="' . $zGenes['symbol'] . '"' . (in_array($zGenes['symbol'], $_GET['genes'])? ' selected' : '') . '>' . $zGenes['symbol'] . ' (' . lovd_shortenString($zGenes['gene'], 50) . ')</OPTION>' . "\n");
}
print('              </SELECT><BR>' . "\n" .
      '              <A href="#" onclick="var list = document.forms[0][\'genes[]\']; for (i=0;i<list.options.length;i++) { list.options[i].selected = true; }; return false">Select all</A>' . "\n" .
      '            </TD>' . "\n" .
      '            <TH colspan="2">Please fill in the search terms in the field' . ($nOriginCols == 1? '' : 's') . ' below</TH></TR>');

// Rest will be generated automatically.
// Array which will make up the form table.
$aForm = array(
                array('GET', '', '', '33%', '33%'),
              );

foreach ($aOriginCols as $sCol) {
    $aForm = array_merge($aForm, $_CURRDB->buildFormTable('Patient', $sCol));
}

// Modify form so it can be used for searching.
foreach ($aForm as $key => $aField) {
    // 2008-01-28; 2.0-04; Added this check to ensure this does not modify the $aForm[0] element or any comments.
    if ($key && $aField[0] != 'print' && $aField[1] != 'print') {
        $aField[2] = 'search_' . $aField[2];
        $aForm[$key] = $aField;
    }
}
$aForm[] = 'skip';
$aForm[] = array('', 'submit', 'Search sequence variants');
$_MODULES->processForm('VariantsOverviewOriginSearch', $aForm);
lovd_viewForm($aForm);

print('</TABLE></FORM><BR>' . "\n\n");

// That's it? Or do we need to search?
$bSearched = false;
foreach ($aOriginCols as $sCol) {
    if (array_key_exists('search_' . $sCol, $_GET) && $_GET['search_' . $sCol]) {
        $bSearched = true;
        break;
    }
}

if (!$bSearched || !count($_GET['genes'])) {
    // Can't search with this.
    require ROOT_PATH . 'inc-bot.php';
    exit;
}





// Per gene, show the variants connected to the patients found by the search terms.
foreach ($_GET['genes'] as $sSymbol) {
    // Whether or not a user can see non-public data.
    $bCurator = lovd_isCurator($sSymbol);

    $_CURRDB = new CurrDB(true, $sSymbol);
    $_CURRDB->hideCols('public', $bCurator);

    // Standard query, will be extended later on.
    $sQ = 'SELECT v.*, p.*, p2v.allele, p2v.status' . ($bCurator? ', stat.status_text AS status_' : '') . ', path.pathogenic_text AS pathogenic_, count(p2v_2.variantid) AS mutations, s.reference AS subs_reference FROM ' . TABLEPREFIX . '_' . $sSymbol . '_variants AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (p2v.symbol = "' . $sSymbol . '" AND v.variantid = p2v.variantid) LEFT JOIN ' . TABLE_PATIENTS . ' AS p USING (patientid) LEFT OUTER JOIN ' . TABLE_PAT2VAR . ' AS p2v_2 ON (p.patientid = p2v_2.patientid' . ($bCurator? '' : ' AND p2v_2.status >= ' . STATUS_MARKED) . ')' . ($bCurator? ' LEFT OUTER JOIN ' . TABLE_VAR_STATUS . ' AS stat ON (p2v.status = stat.status)' : '') . ' LEFT OUTER JOIN ' . TABLE_PATHOGENIC . ' AS path ON (p2v.pathogenic = path.pathogenic) LEFT OUTER JOIN ' . TABLE_SUBS . ' AS s ON (p.submitterid = s.submitterid) WHERE ' . ($bCurator? '1=1' : 'p2v.status >= ' . STATUS_MARKED . ' AND p2v_2.status >= ' . STATUS_MARKED);

    // Guess the column used to describe the mutation.
    $sMutationCol = $_CURRDB->getMutationCol();

    // Here starts the actual building of the query.
    // SEARCH: Simple text search.
    // FIXME; just the origin columns? Simple change to $_CURRDB->buildSearchList() needed, like buildFormTable().
    $aSearchText = $_CURRDB->buildSearchList();
    // FIXME; document advanced searching.
    foreach ($aSearchText as $key => $val) {
        if (isset($_GET[$key]) && trim($_GET[$key])) {
            $a = explode(' ', trim($_GET[$key]));
            foreach ($a as $sTerm) {
                if ($sTerm) {
                    if (substr_count($sTerm, '|') && preg_match('/^[^|]+(\|[^|]+)+$/', $sTerm)) {
                        // OR.
                        $aOR = explode('|', $sTerm);
                        $sQ .= ' AND (';
                        foreach ($aOR as $nTerm => $sTerm) {
                            $sQ .= ($nTerm? ' OR ' : '') . $val . ' LIKE "%' . $sTerm . '%"';
                        }
                        $sQ .= ')';
                    } elseif (substr($sTerm, 0, 1) == '!') {
                        // NOT.
                        $sQ .= ' AND ' . $val . ' NOT LIKE "%' . substr($sTerm, 1) . '%"';
                    } else {
                        // Common search term.
                        $sQ .= ' AND ' . $val . ' LIKE "%' . $sTerm . '%"';
                    }
                }
            }
        }
    }

    // Add p2v.allele here to show homozygous mutations twice in the list.
    $sQ .= ' GROUP BY v.variantid, p.patientid';

    $nResults = mysql_num_rows(mysql_query($sQ));

    // SORT: Current settings.
    if (isset($_GET['order']) && $_GET['order']) {
        $aOrder = explode(',', $_GET['order']);
    } else {
        $aOrder = array('', '');
    }

    // SORT: Column data.
    $aOrderList = array_merge(
             array('pathogenic_' => array('path.pathogenic', 'ASC')),
             array('sort' => array('v.sort', 'ASC')),
             $_CURRDB->buildOrderList());
    if ($bCurator) {
        // Add status.
        $aOrderList['status_'] = array('p2v.status', 'ASC');
    }
    if (!array_key_exists($aOrder[0], $aOrderList)) {
        // 2007-10-19; 2.0-01; Changed default sorting column from Exon to Variant/DNA.
        $aOrder[0] = $sMutationCol;
    }
    if ($aOrder[1] != 'ASC' && $aOrder[1] != 'DESC') {
        $aOrder[1] = $aOrderList[$aOrder[0]][1];
    }

    // 2007-10-19; 2.0-01; Fixed bug #18 - Variants do not sort correctly when selecting DNA column to sort on.
    // SORT: Additional sort columns (faking a perfect sort).
    $sOrderPre = '';
    $sOrderPost = '';
    if (in_array($aOrder[0], array('Variant/DNA', 'Variant/Exon'))) {
        // 1) In case of the mutation column, sort FIRST on Exon, and sort.
        if ($_CURRDB->colExists('Variant/Exon')) {
            $sOrderPre .= 'v.`Variant/Exon` ' . $aOrder[1] . ', ';
        }
        $sOrderPre .= 'v.sort ' . $aOrder[1] . ', ';
    } else {
        // 2) In case of anything else, sort on Exon, and sort AFTER.
        if ($_CURRDB->colExists('Variant/Exon')) {
            $sOrderPost .= ', v.`Variant/Exon` ' . $aOrder[1];
        }
        $sOrderPost .= ', v.sort ' . $aOrder[1];
    }

    $sQ .= ' ORDER BY ' . $sOrderPre . $aOrderList[$aOrder[0]][0] . ' ' . $aOrder[1] . $sOrderPost . ', p.patientid';



    if (!$nResults) {
        // Searched, but no results.
        // We actually didn't check, if you're not a curator for all genes, if variants were public.
        print('      No variants found in the ' . $sSymbol . ' gene that match your search terms.<BR><BR>' . "\n\n");
        continue;
    }

    $q = mysql_query($sQ);
    if (!$q) {
        lovd_dbFout('VariantsOverviewOrigin', $sQ, mysql_error());
    }

    $n = (isset($nResults)? $nResults : $nTotal);
    print('      <SPAN class="S13"><B>' . $n . ($bCurator? '' : ' public') . ' entr' . ($n == 1? 'y' : 'ies') . ' in ' . $sSymbol . '</B></SPAN><BR>' . "\n");

    // Array which will make up the table (header and data).
    $aTable = array('pathogenic_' => array('Path.', 50));
    $aTable = array_merge($aTable, $_CURRDB->buildTable('list'));

    // Additional columns for authorized users.
    if ($bCurator) {
        $aTable['status_'] = array('Status', 75);
    }

    // Stretch it up, cause we're adding data to it...
    if ($aTable[$sMutationCol][1] < 200) {
        $aTable[$sMutationCol][1] = 200;
    }

    // Total width.
    $nTotalWidth = 2;
    foreach ($aTable as $aCol) {
        $nTotalWidth += $aCol[1] + 8;
    }



    // Stretch table up, to respect column widths.
    print('      <IMG src="' . ROOT_PATH . 'gfx/trans.png" alt="" width="' . $nTotalWidth . '" height="1"><BR>' . "\n\n");

    // Table.
    print('      <TABLE border="0" cellpadding="0" cellspacing="1" class="data">' . "\n" .
          '        <TR>');

    foreach ($aTable as $sField => $aCol) {
        // Location onclick changed because of the search fields within the same <TH>. Clicking on the field triggers a sort.
        print("\n" . '          <TH valign="top"' . (isset($aCol[2]) && $aCol[2]? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . (array_key_exists($sField, $aOrderList)? ' class="order' . ($aOrder[0] == $sField? 'ed' : '') . '"' : '') . '>' .
              (array_key_exists($sField, $aOrderList)? "\n" .
                                                           '            <TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="S11">' . "\n" .
                                                           '              <TR' . (array_key_exists($sField, $aOrderList)? ' onclick="document.forms[0].order.value=\'' . $sField . ',' . ($aOrder[0] == $sField? ($aOrder[1] == 'ASC'? 'DESC' : 'ASC') : $aOrderList[$sField][1]) . '\';document.forms[0].submit();"' : '') . '>' . "\n" .
                                                           '                <TH>' . str_replace(' ', '&nbsp;', $aCol[0]) . '</TH>' . "\n" .
                                                           '                <TD align="right"><IMG src="gfx/order_arrow_desc' . ($aOrder[0] == $sField && $aOrder[1] == 'DESC'? '_sel' : '') . '.png" alt="Descending" title="Descending" width="13" height="6"><BR><IMG src="gfx/order_arrow_asc' . ($aOrder[0] == $sField && $aOrder[1] == 'ASC'? '_sel' : '') . '.png" alt="Ascending" title="Ascending" width="13" height="6"></TD></TR>' .
                                                           '</TABLE>' : $aCol[0]) . '</TH>');
    }
    print('</TR>');

    $i = 0;
    $nRepeat = 25;
    while ($zData = mysql_fetch_assoc($q)) {
        // Print header repeatedly.
        $i ++;
        if (!($i%($nRepeat+1))) {
            print("\n" .
                  '        <TR>');
            foreach ($aTable as $sField => $aCol) {
                print("\n" . '          <TH valign="top"' . (isset($aCol[2]) && $aCol[2]? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . (array_key_exists($sField, $aOrderList)? ' class="order' . ($aOrder[0] == $sField? 'ed' : '') . '"' : '') . '>' .
                      (array_key_exists($sField, $aOrderList)? "\n" .
                                                                   '            <TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="S11">' . "\n" .
                                                                   '              <TR' . (array_key_exists($sField, $aOrderList)? ' onclick="document.forms[0].order.value=\'' . $sField . ',' . ($aOrder[0] == $sField? ($aOrder[1] == 'ASC'? 'DESC' : 'ASC') : $aOrderList[$sField][1]) . '\';document.forms[0].submit();"' : '') . '>' . "\n" .
                                                                   '                <TH>' . str_replace(' ', '&nbsp;', $aCol[0]) . '</TH>' . "\n" .
                                                                   '                <TD align="right"><IMG src="gfx/order_arrow_desc' . ($aOrder[0] == $sField && $aOrder[1] == 'DESC'? '_sel' : '') . '.png" alt="Descending" title="Descending" width="13" height="6"><BR><IMG src="gfx/order_arrow_asc' . ($aOrder[0] == $sField && $aOrder[1] == 'ASC'? '_sel' : '') . '.png" alt="Ascending" title="Ascending" width="13" height="6"></TD></TR>' .
                                                                   '</TABLE>' : $aCol[0]) . '</TH>');
            }
            print('</TR>');
            $i = 1;
        }

        print("\n" .
              '        <TR valign="top"' . ($bCurator && $zData['status'] < STATUS_OK? ' class="' . ($zData['status'] < STATUS_MARKED? 'del' : 'marked') . '"' : '') . ' style="cursor : pointer; cursor : hand;" onmouseover="this.className = \'' . ($bCurator && $zData['status'] < STATUS_OK? ($zData['status'] < STATUS_MARKED? 'del_' : 'marked_') : '') . 'hover\';" onmouseout="this.className = \'' . ($bCurator && $zData['status'] < STATUS_OK? ($zData['status'] < STATUS_MARKED? 'del' : 'marked') : '') . '\';" onclick="window.location.href = \'' . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH) . 'variants.php?select_db=' . $sSymbol . '&amp;action=view&amp;view=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . lovd_showSID(true, true) . '\';">');

        // Create normal anchor link as well.
        $sLink = '<A href="' . $_SERVER['PHP_SELF'] . '?select_db=' . $sSymbol . '&amp;action=view&amp;view=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . lovd_showSID(true, true) . '" style="color : #' . ($zData['status'] < STATUS_MARKED? 'AAAAAA' : '000000') . '; text-decoration : none;">';
        if ($sMutationCol) {
            $zData[$sMutationCol] = $sLink . $zData[$sMutationCol] . '</A>';
        }

        // Very unlikely not to function; only if none of the HGVS standard DNA, RNA or Protein fields are enabled, this will fail.
        if ($zData['mutations'] > 1) {
            // Fetch info on other mutations.
            // FIXME; this may be quite a performance lag with a high $_GET['limit'] value and lots of associated mutations.
            // Backwards compatible with MySQL 4.0 and earlier; if we rely on MySQL 4.1, we could do a GROUP_CONCAT in top mutation fetch query that save us these queries.
            $sQOther = 'SELECT p2v.*, v.`' . $sMutationCol . '` FROM ' . TABLE_PAT2VAR . ' AS p2v LEFT OUTER JOIN ' . TABLEPREFIX . '_' . $sSymbol . '_variants AS v ON (p2v.symbol = "' . $sSymbol . '" AND v.variantid = p2v.variantid) WHERE ' . ($bCurator? '' : 'p2v.status >= ' . STATUS_MARKED . ' AND ') . 'p2v.patientid = "' . $zData['patientid'] . '" AND !(p2v.symbol = "' . $sSymbol . '" AND v.variantid = "' . $zData['variantid'] . '" AND p2v.allele = "' . $zData['allele'] . '") ORDER BY ' . ($_CURRDB->colExists('Variant/Exon')? 'v.`Variant/Exon` ASC, ' : '') . 'v.sort ASC';

            $qOther = mysql_query($sQOther);
            $sOther = '';
            $aOther = array();

            // Loop other variants found in the same patient.
            while ($zOther = mysql_fetch_assoc($qOther)) {
                if ($zOther['symbol'] == $sSymbol) {
                    // Other variant in same gene.
                    $sOther .= ($sOther? ', ' : '') . $zOther[$sMutationCol];
                } else {
                    // Other variant in different gene.
                    if (!isset($aOther[$zOther['symbol']])) {
                        $aOther[$zOther['symbol']] = 0;
                    }
                    $aOther[$zOther['symbol']] ++;
                }
            }

            if (count($aOther)) {
                foreach ($aOther as $sGene => $nOther) {
                    $sOther .= ($sOther? ', ' : '') . $sGene . ' (' . $nOther . ')';
                }
            }

            $zData[$sMutationCol] .= '<BR>&nbsp;&nbsp;&nbsp;&nbsp;+ ' . $sOther;

            // FIXME; retrieve other mutations and their genes/alleles, put them all here?
        }

        // Parse and build Custom Links.
        lovd_buildLinks($zData);

        // Transform select lists' values.
        $_CURRDB->transformSelectValues($zData);

        // FIXME;
        // Shorten strings for TEXT that surely doesn't contain HTML tags... HOW?

        // Submitter reference...
        if ($_CURRDB->colExists('Patient/Reference') && $zData['subs_reference']) {
            // FIXME; this will be different soon.
            $zData['Patient/Reference'] .= (!empty($zData['Patient/Reference'])? ', ' : '') . '<A href="' . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH) . 'submitters.php?action=public_list#' . $zData['submitterid'] . '" target="_blank">' . $zData['subs_reference'] . '</A>';
        }

        foreach ($aTable as $sField => $aCol) {
            print("\n" . '          <TD' . (isset($aCol[2]) && $aCol[2]? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . ($aOrder[0] == $sField? ' class="ordered"' : '') . '>' . (!$zData[$sField]? '-' : $zData[$sField]) . '</TD>');
        }
        print('</TR>');
    }
    print('</TABLE><BR>' . "\n\n");
}

require ROOT_PATH . 'inc-bot.php';
exit;
?>