<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-10
 * Modified    : 2008-07-17
 * For LOVD    : 2.0-08
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Setup</H3>
            <H4>Authorized users</H4>

            Besides the public access to LOVD and users registering themselves as a <A href="<?php echo DOCS_PATH; ?>lovd_setup/submitters.php">submitter</A> to add new variants to the database, the users who are setting up LOVD and curating the variants are all authorized LOVD users who need to have their account created by others. The authorized users come in three levels; the database administrator of which there is only one, managers, and curators.<BR>
            <BR>

            The database administrator has full access to LOVD and can create managers and curators. Managers have access to almost everything, except uninstalling LOVD and creating other managers. Curators do not have access to the setup area and are restricted to the genes they are appointed to.<BR>
            <BR>

            <H5>User levels</H5>

            Creating, editing and deleting users is only possible with users with a lower level than you. So when you are a manager, you can create, edit and delete curators only. The database administrator can create, edit and delete managers and curators.<BR>
            <BR>

            <H6>Database administrator</H6>

            The database administrator is the first user within LOVD; this account is created during the installation of LOVD. After installation, the adminstrator can create other users (managers and curators) in the system, if desired. The administrator has full access to all areas and settings of LOVD. The administrator is also the only user who can uninstall LOVD, provided the uninstall lock has not been set at LOVD installation.<BR>
            <BR>

            When the "Forward messages to database admin" setting in the <A href="<?php echo DOCS_PATH; ?>lovd_setup/lovd_system_settings.php">LOVD system settings</A> is enabled, the database administrator will receive copies of submitter registrations and variant submissions.<BR>
            <BR>

            <H6>Manager</H6>

            A manager has access to almost everything the database administrator has access to. However, the manager is not able to create new managers or to edit existing managers. Also, a manager cannot uninstall LOVD even if the uninstall lock is not in place.<BR>
            <BR>
            A manager can only be created by the administrator and often assists the administrator or takes over the customisation of LOVD for the curators.<BR>
            <BR>

            <H6>Curator</H6>
            
            A curator only has access to the gene databases he or she is appointed to. Also the database administrator or a manager can act as a curator, so no separate accounts are required. But the curator user level is very useful for allowing users access to certain genes while access to LOVD system wide settings and such is restricted.<BR>
            <BR>

            You can set an authorized user as a gene curator by editing the user's account and selecting the relevant genes in the "Curator for" field.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
