<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2007-01-23
 * Modified    : 2007-01-23
 * For LOVD    : 2.0-alpha-05
 *
 * Access      : Public
 * Purpose     : Declare LOVD functions needed for the columns pages.
 *
 * Copyright   : 2004-2007 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

function lovd_describeFormType ($zData) {
    // Returns sensible form type information based on form type code.

    if (!is_array($zData) || empty($zData['form_type']) || substr_count($zData['form_type'], '|') < 2) {
        return false;
    }

    $aFormType = explode('|', $zData['form_type']);
    $sFormType = ucfirst($aFormType[1]);
    switch ($aFormType[1]) {
        case 'text':
        case 'password':
            $sFormType .= ' (' . $aFormType[2] . ' chars)';
            break;
        case 'textarea':
            $sFormType .= ' (' . $aFormType[2] . ' cols, ' . $aFormType[3] . ' rows)';
            break;
        case 'select':
            $nOptions = substr_count($zData['select_options'], "\r\n") + 1;
            if ($nOptions) {
                $sFormType .= ' (' . ($aFormType[4] == 'true'? 'multiple; ' : '') . $nOptions . ' option' . ($nOptions == 1? '' : 's') . ')';
            }
            break;
    }

    return $sFormType;
}
?>