<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-09-18
 * Modified    : 2008-09-18
 * For LOVD    : 2.0-12
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Scripts</H3>
            <H4>Reference Sequence Parser</H4>

            LOVD currently comes with one script that is very useful if you want to create coding DNA reference sequences for the genes in your database. For it to work, you will need to make the refseq directory writable. If you also want the script to generate a GenBank file for you, you'll also need to make the genbank directory writable.<BR>
            <BR>

            <H5>Making the refseq and genbank directories writable</H5>
            Your LOVD package comes with two directories called 'refseq' and 'genbank'. As explained above, these directories need to be made writable. Making the 'genbank' directory writable is only necessary if you want the reference sequence parser to generate a GenBank file for you. Below we will explain how to do that on Unix/Linux systems. If your LOVD is installed on a different server (Windows, Macintosh), please contact the person responsible for that server in order to make the directory world writable.<BR>
            <BR>

<?php lovd_showInfoTable('<B>For advanced users</B><BR>It is actually more secure to do a \'chgrp\' on the folder to the user running the webserver, than to make the directory world writable. If you don\'t know which user the webserver runs as (i.e. \'www-data\' or \'httpd\'), you will need to do a \'ps\' to find out which user that is. After that, make sure the groupbit has been set to 7 (rwx). This way, the Reference Sequence Parser works without having to make the refseq directory world writable.', 'information'); ?>

            <B>Using the commandline</B><BR>
            <OL style="margin-top : 0px;">
              <LI>Log in to the server using SSH, telnet or any non-graphical (S)FTP client.</LI>
              <LI>Move into the directory LOVD is placed using the 'cd' command.</LI>
              <LI>Type in 'chmod 777 refseq genbank'.</LI>
              <LI>Check if the Reference Sequence Parser is still generating an error. If not, you're done.</LI>
            </OL><BR>

            <B>Using a graphical (S)FTP client</B><BR>
            Of course, there are so many different FTP clients that I can't write a exact manual on how to change rights on a folder. This will describe a generally used method.<BR>
            <OL style="margin-top : 0px;">
              <LI>Log in to the server using your favorite (S)FTP client.<BR>
                (FTP is a protocol used to transfer files to or from the internet. If you have uploaded your LOVD files to a server, you can use the same program you used then.)</LI>
              <LI>Move into the directory LOVD is placed (usually by double clicking on the folder names).</LI>
              <LI>Right click on the folder 'refseq', this will bring up a menu.</LI>
              <LI>Select 'chmod' if it is an option. Otherwise, click 'Properties' and look for the folder permissions/rights.</LI>
              <LI>Fill in '777' as the new value.</LI>
              <LI>Repeat steps 3-5 for the 'genbank' directory.</LI>
              <LI>Check if the Reference Sequence Parser is still generating an error. If not, you're done.</LI>
            </OL><BR>

            <H5>Input formats Reference Sequence Parser</H5>
            The Reference Sequence Parser accepts specific input formats for each step. Step 1 requires a GenBank file, and will generate the formats for steps 2 and 3 automatically, so starting at this step is recommended.<BR>
            Step 2 requires the genomic sequence formatted to provide the positions of the upstream sequence, exons, introns, downstream sequence and the start of the translation.<BR>
            Step 3 requires the coding DNA sequence formatted to provide the positions of the exon borders and the start of the translation.<BR>
            All formats are case-<B>in</B>sensitive. It does not matter whether you use capital or non-capital nucleotides.<BR>
            <BR>

            <B>Input format for step 1</B><BR>
            Step 1 requires a valid GenBank file, uploaded into the 'genbank' directory. Preferably, the GenBank file contains only your gene of interest and only one transcript is defined. If more than one transcript is defined, select the number as the "mRNA field" value on the form of step 1.<BR>
            <BR>

            Step 1 will create the correct format for step 2, so this is the recommended step to start out with.<BR>
            <BR>

            <B>Input format for step 2</B><BR>
            <I>UPSTREAM&lt;EXON&gt;INTRON&lt;EXON&gt;INTRON&lt;EXON&gt;INTRON (...etc...) &lt;EXON&gt;DOWNSTREAM</I><BR>

            Make sure you include the starting point of the translation by putting a '|' in front of the 'a' of the 'atg' starting codon. If you started at step 1, this is done for you automatically.<BR>
            <BR>

            Example:<BR>
            <I>cccccccc&lt;gggggg|at&gt;tttttttt&lt;gggggggg&gt;aaaaaaaa</I><BR>
            will parse:<BR>

            - 'cccccccc' as the upstream sequence.<BR>
            - 'ggggggat' as exon 1, with the translation starting at the 'a'.<BR>
            - 'tttttttt' as intron 1.<BR>
            - 'gggggggg' as exon 2.<BR>
            - 'aaaaaaaa' as the downstream sequence.<BR>
            <BR>

            Step 2 will create the upstream sequence, intronic sequences and the downstream sequence and save them in the refseq directory. It will also create the input for step 3 for you.<BR>
            <BR>

            <B>Input format for step 3</B><BR>
            <I>EXON;EXON;EXON; (...etc...) ;EXON</I><BR>
            Make sure you include the starting point of the translation by putting a '|' in front of the 'a' of the 'atg' starting codon. If you started at step 1 or 2, the same start codon is used.<BR>

            <BR>

            Example:<BR>
            <I>gggggg|at;gggggggg</I><BR>
            will parse:<BR>
            - 'ggggggat' as exon 1, with the translation starting at the 'a'.<BR>
            - 'gggggggg' as exon 2.<BR>

            <BR>
            Step 3 will create the coding DNA sequence including the translation and save it in the refseq directory.<BR>
            <BR>

            For examples on how these reference sequences will look like, take a look at the reference sequences <A href="http://www.dmd.nl/" target="_blank">www.DMD.nl</A>, such as the <A href="http://www.dmd.nl/nmdb2/refseq/CAPN3_codingDNA.html" target="_blank">CAPN3 reference sequence</A>.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
