<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-24
 * Modified    : 2008-07-25
 * For LOVD    : 2.0-09
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>Variant and patient data</H3>
            <H4>Importing text files</H4>

            LOVD supports importing your variant and patient information from tab delimited text files, data preferably enclosed by double quotes. These can be taken from a LOVD download, or saved from a spreadsheet program such as OpenOffice.org Calc or MS Excel. You do not need to send the file to the server using FTP, as was done with LOVD 1.1.0. The exact list of columns needed is dependent on your LOVD configuration. If you're unsure, make a full <A href="<?php echo DOCS_PATH; ?>lovd_gene_configuration_area/download_or_import_variants.php">download of your gene</A> in the configuration area.<BR>
            <BR>

<?php
lovd_showInfoTable('Please NOTE that spreadsheets are well known for introducing errors in importing/exporting text files, due to automatic interpretation of the values. Before using a spreadsheet program to edit a downloaded file, format all cells to "Text".', 'warning');
?>

            If you're converting your own spreadsheet data to LOVD format, please read the following notes carefully. Always start out with a LOVD download file, so you have the correct headers!<BR>
            <BR>

            <OL>
              <LI>
                The first line should contain the version number and is very important in versions 2.0-04 and up, but should be left out in older versions of LOVD. If you do not include this line, LOVD will assume it's an old import format, and will alter the pathogenicity settings. The line should say something like:<BR>
                <BR>
                <SPAN class="S09">### LOVD-version 2000-040 ### Do not remove this line, unless importing in versions before 2.0-04 ###</SPAN><BR>
                <BR>
              </LI>
              <LI>
                The second line contains the column names and is essential. LOVD looks at these column names to check if all required columns are present. The order of the columns does not matter.<BR>
                <BR>
              </LI>
              <LI>
                If there are mandatory columns missing from the import file, you get a warning and nothing is imported.<BR>
                <BR>
              </LI>
              <LI>
                If non-mandatory columns are missing, the column value will remain empty for the imported variants.<BR>
                <BR>
              </LI>
              <LI>
                Columns which are present in the file, but not in the database, are <B>ignored</B>.<BR>
                <BR>
              </LI>
              <LI>
                The ID* columns, such as ID_allele_ and ID_pathogenic_, contain numeric references representing values that will appear on the screen. The meaning of the (often numeric) values of these columns are listed below:<BR>

                <PRE>
    ID_allele_ (optional)
    0 => Unknown
    1 => Parent #1
    2 => Parent #2
    10 => Paternal (inferred)
    11 => Paternal (confirmed)
    20 => Maternal (inferred)
    21 => Maternal (confirmed)
                </PRE>

<?php
lovd_showInfoTable('<B>Please note that the below values for pathogenicity have changed as of LOVD version 2.0 build 04.</B> If you\'re importing anything in an older version of LOVD, do not use these values, but scroll down for the older values.', 'warning');
?>

                <PRE>
    ID_pathogenic_ (optional)
    This should contain two numbers; the first for the reported
    pathogenicity and one for the concluded pathogenicity.
    1 => No known pathogenicity
    3 => Probably no pathogenicity
    5 => Unknown
    7 => Probably pathogenic
    9 => Pathogenic</PRE>

                So 95 means a mutation is supposedly pathogenic, but this has not been proven.<BR>
                <BR>

                All options are:
                <PRE>
    11 => -/-
    13 => -/-?
    15 => -/?
    17 => -/+?
    19 => -/+
    31 => -?/-
    33 => -?/-?
    35 => -?/?
    37 => -?/+?
    39 => -?/+
    51 => ?/-
    53 => ?/-?
    55 => ?/?
    57 => ?/+?
    59 => ?/+
    71 => +?/-
    73 => +?/-?
    75 => +?/?
    77 => +?/+?
    79 => +?/+
    91 => +/-
    93 => +/-?
    95 => +/?
    97 => +/+?
    99 => +/+
                </PRE>

<?php
lovd_showInfoTable('<B>If you\'re importing in LOVD 2.0-03 or earlier, use this list of pathogenicity values and make sure there is no version code on top of the imported file.</B>
                <PRE>
    0 => No known pathogenicity
    1 => Pathogenic
    9 => Unknown</PRE>

                All options are:
                <PRE>
    00 => -/-
    01 => -/+
    09 => -/?
    10 => +/-
    11 => +/+
    19 => +/?
    90 => ?/-
    91 => ?/+
    99 => ?/?</PRE>', 'warning');
?>

                <PRE>
    ID_status_ (optional)
    1 => Submitted
    4 => Non public
    7 => Marked
    9 => Public
                </PRE>

                <SPAN style="font-family : monospace;">&nbsp;&nbsp;&nbsp;&nbsp;ID_variantid_</SPAN><BR>
                This contains the internal variant ID (numeric). If your database is empty, you can start counting from 1. If variants are equal, you can copy all variant fields including the variant ID in the file. If a variant is already in the database, use that variant ID. The import script will then check if the data in the file equals the data in the database.<BR>
                <BR>

                <SPAN style="font-family : monospace;">&nbsp;&nbsp;&nbsp;&nbsp;ID_patientid_</SPAN><BR>
                This contains the internal patient ID (numeric). If your database is empty, you can start counting from 1. If the patient has more than one variant, you can copy all patient fields including the patient ID in the file. If a patient is already in the database, use that patient ID. The import script will then check if the data in the file equals the data in the database.<BR>
                <BR>

                <SPAN style="font-family : monospace;">&nbsp;&nbsp;&nbsp;&nbsp;ID_submitterid_ (optional)</SPAN><BR>
                The submitter ID of the submitter who's submitted this patient.<BR>
                <BR>

                <SPAN style="font-family : monospace;">&nbsp;&nbsp;&nbsp;&nbsp;ID_variant_created_by_ (optional)<BR>
                &nbsp;&nbsp;&nbsp;&nbsp;ID_variant_edited_by_ (optional)</SPAN><BR>
                The user ID of the user who's created and/or edited this variant data.<BR>
                <BR>

                <SPAN style="font-family : monospace;">&nbsp;&nbsp;&nbsp;&nbsp;ID_patient_created_by_ (optional)<BR>
                &nbsp;&nbsp;&nbsp;&nbsp;ID_patient_edited_by_ (optional)</SPAN><BR>
                The user ID of the user who's created and/or edited this patient data.<BR>
                <BR>
              </LI>
              <LI>
                Date fields (variant_created_date_, variant_edited_date_, patient_created_date_ and patient_edited_date_; all optional) should contain a date in the format YYYY-MM-DD HH:MM:SS (2007-05-21 11:57:31).<BR>
                <BR>
              </LI>
              <LI>
                You can then import the file back into LOVD through the configuration area (Configuration > Import new variant and patient data). You don't need to send the file through FTP, like in LOVD 1.1.0.<BR>
                <BR>
              </LI>
            </UL>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
