<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2008-12-16
 * Modified    : 2009-02-02
 * For LOVD    : 2.0-15
 *
 * Access      : Public
 * Purpose     : Download all custom columns currently in the database.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 *               Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// Require manager clearance.
lovd_requireAUTH(LEVEL_MANAGER);





// Headers.
header('Content-Type: text/plain; charset=ISO-8859-1');
header('Content-Disposition: attachment; filename="LOVD_custom_columns_' . date('Y-m-d_H.i.s') . '.txt"');
// Fix IE download issue when using SSL.
header('Pragma: public');
// Add format version number and Custom Columns.
print('### LOVD-version ' . lovd_calculateVersion($_SETT['system']['version']) . ' ### Columns ### Do not remove this line! ###' . "\n");

$q = mysql_query('SELECT * FROM ' . TABLE_COLS . ' ORDER BY colid');
$zData = mysql_fetch_assoc($q);
$aCols = array_keys($zData);

// First print the column headers.
foreach ($aCols as $i => $sField) {
    print(($i? "\t" : '') . '"{{ ' . $sField . ' }}"');
}
print("\n");

// Now print the contents of the database.
do {
    // Quote data.
    lovd_magicQuote($zData);
    $zData = str_replace(array("\r\n", "\r", "\n"), array('\r\n', '\r', '\n'), $zData);

    print('"' . implode("\"\t\"", $zData) . "\"\n");
} while ($zData = mysql_fetch_assoc($q));
?>
