<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2008-09-04
 * Modified    : 2008-10-17
 * For LOVD    : 2.0-13
 *
 * Access      : Public
 * Purpose     : 
 *
 * Copyright   : 2004-2008 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 *               Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

function lovd_determineLocation($sDNA) {
    // Function to determine the location of DNA variants (5'ATG, coding, intron, 3'stop)
    if (preg_match("/[0-9]+[\+\-][0-9]+/", $sDNA)) {
        //variant is located in an intron
        return 2;
    } elseif (preg_match("/\-[0-9]+/", $sDNA)) {
        //variant is located before the 5' ATG start codon
        return 0;
    } elseif (preg_match("/\*[0-9]+/", $sDNA)) {
        //variant is located after the 3' stop codon
        return 3;
    } else {
        //variant is located in the coding region
        return 1;
    }
}

$nBarWidth = 600;// Set the width for a 100% bar

// Array with row headers for the final output tables
$aVariants['sub']           = 'substitutions';
$aVariants['del']           = 'deletions';
$aVariants['dup']           = 'duplications';
$aVariants['ins']           = 'insertions';
$aVariants['delins']        = 'insertion/duplications';
$aVariants['inv']           = 'inversions';
$aVariants['twovars']       = '2 variants in 1 allele';
$aVariants['spl']           = 'splice variants';
$aVariants['fs']            = 'frame shifts';
$aVariants['no protein']    = 'no protein variants';
$aVariants['p.X']           = 'no-stop variants';
$aVariants['X']             = 'nonsense';
$aVariants['p.0']           = 'no translation variants';
$aVariants['p.Met']         = 'translation initiation variant';
$aVariants['=']             = 'silent';
$aVariants['complex']       = 'complex';
$aVariants['unknown']       = 'unknown';


// create regular expressions to be used later on
$sFraShift      = "/fs/";                                               // frame shift
$sFra2Shift     = "/ins[a-zA-z]{1,3}[a-zA-z]{1,3}X/";                   // frame shift
$sNoStop        = "/extX/";                                             // no stop
$sNoProtein     = "/p\.0\?/";                                           // no protein
$sNonsense      = "/X/";                                                // nonsense
$sNoTransl      = "/p\.0/";                                             // no translation
$sTransInit     = "/p\.Met/";                                           // translation initiation
$sSilent        = "/=/";                                                // silent
$sUnknown       = "/\?/";                                               // unknown
$sSplice        = "/spl/";                                              // splice variant
$sDelIns        = "/del(\w)*ins/";                                      // insertion/deletion
$sInv           = "/inv/";                                              // inversion
$sIns           = "/ins/";                                              // insertion
$sDup           = "/dup/";                                              // duplication
$sDel           = "/del/";                                              // deletion
$sSub           = "/>/";                                                // substitution
$sProtSub       = "/(^p\.)?(\()?[a-zA-Z]{1,}(\d)+[a-zA-Z]{1,}(\))?$/";  // protein substitution
$sComma         = "/,/";                                                // a comma denotes a comples situation
$sTwoVars       = "/\;/";                                               // a semicolon denotes 2 mutations in 1 allele

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// If no gene selected, present the selection list.
if (!$_SESSION['currdb'] || $_GET['action'] == 'switch_db') {
    lovd_switchDB();
}

// Whether or not a user can see non-public data.
if (lovd_isCurator($_SESSION['currdb'])) {
    define('IS_CURATOR', true);
} else {
    define('IS_CURATOR', false);
}

// Provide gene homepage.
require ROOT_PATH . 'inc-top.php';
lovd_printGeneHeader();
lovd_printHeader('variant_statistics', 'LOVD - Variant statistics summary');

list($nTotal) = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_PAT2VAR . ' AS t1 WHERE t1.symbol = "' . $_SESSION['currdb'] . '" AND ' . (IS_CURATOR? '1=1' : 't1.status >= ' . STATUS_MARKED)));
if (!$nTotal) {
    print('      There are currently no ' . (IS_CURATOR? '' : 'public ') . 'variants in this gene.<BR>' . "\n");
    lovd_printGeneFooter();
    require ROOT_PATH . 'inc-bot.php';
    exit;
}

// To check availability of the Variant/DNA, Variant/RNA, Variant/Protein and Patient/Times_reported columns, we need the CurrDB class.
require ROOT_PATH . 'class/currdb.php';
$_CURRDB = new CurrDB();

// Counting the DNA variants

if ($_CURRDB->colExists('Variant/DNA')) {
    // Checking the DNA column
    
    // initialize arrays for counting locations of DNA variants (5'ATG, coding, intron, 3'stop)
    $aLocationSub       = array(0, 0, 0, 0);    //substitutions
    $aLocationDel       = array(0, 0, 0, 0);    //deletions
    $aLocationDup       = array(0, 0, 0, 0);    //duplications
    $aLocationIns       = array(0, 0, 0, 0);    //insertions
    $aLocationDelIns    = array(0, 0, 0, 0);    //insertions/deletions
    $aLocationInv       = array(0, 0, 0, 0);    //inversions

    // Initialize the counter array
    $aCounts = array();
    $aCounts['sub']     = $aLocationSub;    //substitutions
    $aCounts['del']     = $aLocationDel;    //deletions
    $aCounts['dup']     = $aLocationDup;    //duplications
    $aCounts['ins']     = $aLocationIns;    //insertions
    $aCounts['delins']  = $aLocationDelIns;    //insertions/deletions
    $aCounts['inv']     = $aLocationInv;    //inversions
    $aCounts['twovars'] = 0;    //2 variants in 1 allel
    $aCounts['complex'] = 0;    //complex variants
    $aCounts['unknown'] = 0;    //unknown variants

    // Initialize the total sum of the counter array
    $nTotalSum = 0;

    if ($_CURRDB->colExists('Patient/Times_Reported')) {
        // Use the Times_Reported column to count the number of patients.
        $qDNA = mysql_query('SELECT v.`Variant/DNA`, SUM(p.`Patient/Times_Reported`) AS sum ' . 
                            'FROM ' . TABLE_CURRDB_VARS . ' AS v ' .
                            'LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v USING (variantid) ' .
                            'LEFT JOIN ' . TABLE_PATIENTS . ' AS p ON (p2v.patientid = p.patientid) ' .
                            'WHERE p2v.symbol = "' . $_SESSION['currdb'] . '"' . (IS_CURATOR? '' : ' AND p2v.status >= ' . STATUS_MARKED) .
                            ' GROUP BY v.`Variant/DNA`');
    } else {
        // No Times_Reported column found, consider every patient entry to be one case.
        $qDNA = mysql_query('SELECT v.`Variant/DNA`, COUNT(p2v.patientid) AS sum ' .
                            'FROM ' . TABLE_CURRDB_VARS . ' AS v ' .
                            'LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v USING (variantid) ' .
                            'WHERE p2v.symbol = "' . $_SESSION['currdb'] . '"' . (IS_CURATOR? '' : ' AND p2v.status >= ' . STATUS_MARKED) .
                            ' GROUP BY v.`Variant/DNA`');
    }
    while ($r = mysql_fetch_row($qDNA)) {
        list($sDNA, $nCount) = $r;
        if (preg_match($sUnknown, $sDNA) || !$sDNA) {
            // unknown variant
            $aCounts['unknown'] += $nCount;
        } elseif (preg_match($sTwoVars, $sDNA)) {
            // two variants in one allele
            $aCounts['twovars'] += $nCount;
        } elseif (preg_match($sDelIns, $sDNA)) {
            // variant is an indel
            $aCounts['delins'][lovd_determineLocation($sDNA)] += $nCount;
        } elseif (preg_match($sInv, $sDNA)) {
            // variant is an inversion
            $aCounts['inv'][lovd_determineLocation($sDNA)] += $nCount;
        } elseif (preg_match($sIns, $sDNA)) {
            // variant is an insertion
            $aCounts['ins'][lovd_determineLocation($sDNA)] += $nCount;
        } elseif (preg_match($sDup, $sDNA)) {
            // variant is a duplication
            $aCounts['dup'][lovd_determineLocation($sDNA)] += $nCount;
        } elseif (preg_match($sDel, $sDNA)) {
            // variant is a deletion
            $aCounts['del'][lovd_determineLocation($sDNA)] += $nCount;
        } elseif (preg_match($sSub, $sDNA)) {
            // variant is a substitution
            $aCounts['sub'][lovd_determineLocation($sDNA)] += $nCount;
        } else {
            // variant is complex
            $aCounts['complex'] += $nCount;
        }
    }

    
    // Calculate the total number of variants (total sum of the counter array)
    foreach ($aCounts as $variant => $number) {
        if (is_array($aCounts[$variant])) {
                $nTotalSum += array_sum($aCounts[$variant]);
        } else {
                $nTotalSum += $aCounts[$variant];
        }
    }

    // After fetching and counting data, print it to the screen.
    // Table in a fixed order, also print zero values
    // Print percentages in horizontal bars
    print('      <SPAN class="S15"><B>DNA variants</B></SPAN><BR>' . "\n" .
          '      <TABLE border cellpadding="2">' . "\n" .
          '        <TR>' . "\n" .
          '          <TH>variant</TH>' . "\n" .
          '          <TH>number</TH>' . "\n" .
          '          <TH colspan=4>location</TH>' . "\n" .
          '          <TH colspan=4>percentages</TH></TR>' . "\n" .
          '        <TR>' . "\n" .
          '          <TH>&nbsp;</TH>' . "\n" .
          '          <TH>&nbsp;</TH>' . "\n" .
          '          <TH>5\'start</TH>' . "\n" .
          '          <TH>coding</TH>' . "\n" .
          '          <TH>intron</TH>' . "\n" .
          '          <TH>3\'stop</TH></TR>' . "\n");
    foreach ($aCounts as $variant => $number) {
        // Print for each variant type a row. 
        if (is_array($aCounts[$variant])) {
            // The substitutions, deletions, duplications, insertions, indels and inversions
            // can be subdivided according to their location (before the 5' start, coding, intron
            // or after the 3' stop
            // First calculate the sum of the number of variants and print the row header and the total number for this variant
            $nVariantsSum = array_sum($aCounts[$variant]);
            print('        <TR>' . "\n" .
                  '          <TD>' . $aVariants[$variant] . '</TD>' . "\n" .
                  '          <TD>' . $nVariantsSum . '</TD>' . "\n");
            // Now print the numbers for each location
            foreach ($aCounts[$variant] as $location => $locnumber) {
                print('          <TD>' . $locnumber . '</TD>' . "\n");
            }
        } else {
            // The other variants
            // First calculate the sum of the number of variants
            $nVariantsSum = $aCounts[$variant];
            print('        <TR>' . "\n" .
                  '          <TD>' . $aVariants[$variant] . '</TD>' . "\n" .
                  '          <TD>' . $nVariantsSum . '</TD>' . "\n");
            // Now print 4 times a '-'
            for ($i = 0; $i < 4; $i++) {
                print('          <TD>-</TD>' . "\n");
            }
        }
        // Print the bar with a length relative to the total for this variant.
        $sPercentage = round(($nVariantsSum ? $nVariantsSum : 0)/$nTotalSum*100, 2) . '%';
        print('          <TD><IMG src="' . ROOT_PATH . 'gfx/lovd_summ_red.png" alt="' . $sPercentage . '" title="' . $sPercentage . '" width="' . round(($nVariantsSum ? $nVariantsSum : 0)/$nTotalSum*$nBarWidth) . '" height="15"></TD></TR>' . "\n");
    }

    // Totals row
    print('        <TR>' . "\n" .
          '          <TD>totals</TD>' . "\n" .
          '          <TD>' . $nTotalSum . '</TD>' . "\n");
    for ($i = 0; $i < 4; $i++) {
        print('          <TD>' . 
              ($aCounts['sub'][$i] + 
               $aCounts['del'][$i] + 
               $aCounts['dup'][$i] + 
               $aCounts['ins'][$i] + 
               $aCounts['delins'][$i] + 
               $aCounts['inv'][$i]) . 
              '</TD>' . "\n");
    }
    print('          <TD><IMG src="' . ROOT_PATH . 'gfx/lovd_summ_red.png" alt="100%" title="100%" width="' . $nBarWidth . '" height="15"></TD></TR></TABLE><BR>' . "\n\n\n\n");
}




// Counting the RNA variants
if ($_CURRDB->colExists('Variant/RNA')) {
    $nTotalSum = 0;
    // Checking the RNA column.


    // Initialize the counter array
    $aCounts = array();
    $aCounts['sub']     = 0;    //substitutions
    $aCounts['del']     = 0;    //deletions
    $aCounts['dup']     = 0;    //duplications
    $aCounts['ins']     = 0;    //insertions
    $aCounts['delins']  = 0;    //insertions/deletions
    $aCounts['inv']     = 0;    //inversions
    $aCounts['spl']     = 0;    //splice variants
    $aCounts['twovars'] = 0;    //2 variants in 1 allel
    $aCounts['complex'] = 0;    //complex variants
    $aCounts['unknown'] = 0;    //unknown variants


    if ($_CURRDB->colExists('Patient/Times_Reported')) {
        // Use the Times_Reported column to count the number of patients.
        $qRNA = mysql_query('SELECT v.`Variant/RNA`, SUM(p.`Patient/Times_Reported`) AS sum FROM ' . TABLE_CURRDB_VARS . 
                            ' AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v USING (variantid) LEFT JOIN ' . TABLE_PATIENTS . 
                            ' AS p ON (p2v.patientid = p.patientid) WHERE p2v.symbol = "' .$_SESSION['currdb'] . 
                            '"' . (IS_CURATOR? '' : ' AND p2v.status >= ' . STATUS_MARKED) . 
                            ' GROUP BY v.`Variant/RNA`');
    } else {
        // No Times_Reported column found, consider every patient entry to be one case.
        $qRNA = mysql_query('SELECT v.`Variant/RNA`, COUNT(p2v.patientid) AS sum FROM ' . TABLE_CURRDB_VARS . ' AS v ' .
                            'LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v' .
                            'USING (variantid)' .
                            ' WHERE p2v.symbol = "' . $_SESSION['currdb'] . '"' . (IS_CURATOR? '' : ' AND p2v.status >= ' . STATUS_MARKED) .
                            ' GROUP BY v.`Variant/RNA`');
    }
    while ($r = mysql_fetch_row($qRNA)) {
        list($sRNA, $nCount) = $r;
        if (preg_match($sUnknown, $sRNA) || !$sRNA) {
            // unknown variant
            $aCounts['unknown'] += $nCount;
        } elseif (preg_match($sTwoVars, $sRNA)) {
            // two variants in one allele
            $aCounts['twovars'] += $nCount;
        } elseif (preg_match($sSplice, $sRNA)) {
            // splice variant
            $aCounts['spl'] += $nCount;
        } elseif (preg_match($sComma, $sRNA)) {
            // complex variant
            $aCounts['complex'] += $nCount;
        } elseif (preg_match($sDelIns, $sRNA)) {
            // variant is an indel
            $aCounts['delins'] += $nCount;
        } elseif (preg_match($sInv, $sRNA)) {
            // variant is an inversion
            $aCounts['inv'] += $nCount;
        } elseif (preg_match($sIns, $sRNA)) {
            // variant is an insertion
            $aCounts['ins'] += $nCount;
        } elseif (preg_match($sDup, $sRNA)) {
            // variant is an duplication
            $aCounts['dup'] += $nCount;
        } elseif (preg_match($sDel, $sRNA)) {
            // variant is an deletion
            $aCounts['del'] += $nCount;
        } elseif (preg_match($sSub, $sRNA)) {
            // variant is an substitution
            $aCounts['sub'] += $nCount;
        } else {
            // complex variant
            $aCounts['complex'] += $nCount;
        }
    }

    // After fetching and counting data, print it to the screen.
    // Print percentages in horizontal bars
    print('      <SPAN class="S15"><B>RNA variants</B></SPAN><BR>' . "\n" .
          '      <TABLE border="1">' . "\n" .
          '        <TR>' . "\n" .
          '          <TH>variant</TH>' . "\n" .
          '          <TH>number</TH>' . "\n" .
          '          <TH>percentages</TH></TR>' . "\n");
    foreach ($aCounts as $variant => $number) {
        $sPercentage = round(($aCounts[$variant] ? $aCounts[$variant] : 0)/array_sum($aCounts)*100, 2) . '%';
        print('        <TR>' . "\n" .
              '          <TD>' . $aVariants[$variant] . '</TD>' . "\n" .
              '          <TD>' . $aCounts[$variant] . '</TD>' . "\n" .
              '          <TD><IMG src="' . ROOT_PATH . 'gfx/lovd_summ_red.png" alt="' . $sPercentage . '" title="' . $sPercentage . '" width="' . round(($aCounts[$variant] ? $aCounts[$variant] : 0)/array_sum($aCounts)*$nBarWidth) . '" height="15"></TD></TR>' . "\n");
    }
    // Totals row
    print('        <TR>' . "\n" .
          '          <TD>totals</TD>' . "\n" .
          '          <TD>' . array_sum($aCounts) . '</TD>' . "\n" .
          '          <TD><IMG src="' . ROOT_PATH . 'gfx/lovd_summ_red.png" alt="100%" title="100%" width="' . $nBarWidth . '" height="15"></TD></TR></TABLE><BR>' . "\n\n\n\n");
}




// Counting the Protein variants
if ($_CURRDB->colExists('Variant/Protein')) {
    $nTotalSum = 0;
    // Checking the Protein column.

    // Initialize the counter array
    $aCounts = array();
    $aCounts['sub']         = 0; //substitutions
    $aCounts['del']         = 0; //deletions
    $aCounts['dup']         = 0; //duplications
    $aCounts['ins']         = 0; //insertions
    $aCounts['delins']      = 0; //insertions/deletions
    $aCounts['twovars']     = 0; //2 variants in 1 allel
    $aCounts['fs']          = 0; //frame shift
    $aCounts['no protein']  = 0; //no protein
    $aCounts['p.X']         = 0; //no stop
    $aCounts['X']           = 0; //nonsense
    $aCounts['p.0']         = 0; //no translation
    $aCounts['p.Met']       = 0; //translation initiation
    $aCounts['=']           = 0; //silent
    $aCounts['complex']     = 0; //complex variants
    $aCounts['unknown']     = 0; //unknown variants

    
    if ($_CURRDB->colExists('Patient/Times_Reported')) {
        // Use the Times_Reported column to count the number of patients.
        $qProtein = mysql_query('SELECT v.`Variant/Protein`, SUM(p.`Patient/Times_Reported`) AS sum FROM ' . TABLE_CURRDB_VARS . 
                            ' AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v USING (variantid) LEFT JOIN ' . TABLE_PATIENTS . 
                            ' AS p ON (p2v.patientid = p.patientid) WHERE p2v.symbol = "' .$_SESSION['currdb'] . 
                            '"' . (IS_CURATOR? '' : ' AND p2v.status >= ' . STATUS_MARKED) . 
                            ' GROUP BY v.`Variant/Protein`');
    } else {
        // No Times_Reported column found, consider every patient entry to be one case.
        $qRNA = mysql_query('SELECT v.`Variant/Protein`, COUNT(p2v.patientid) AS sum FROM ' . TABLE_CURRDB_VARS . ' AS v ' .
                            'LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v' .
                            'USING (variantid)' .
                            ' WHERE p2v.symbol = "' . $_SESSION['currdb'] . '"' . (IS_CURATOR? '' : ' AND p2v.status >= ' . STATUS_MARKED) .
                            ' GROUP BY v.`Variant/Protein`');
    }
    while ($r = mysql_fetch_row($qProtein)) {
        list($sProtein, $nCount) = $r;
        if (preg_match($sNoProtein, $sProtein)) {
            // no protein variant
            $aCounts['no protein'] += $nCount;
        } elseif (preg_match($sUnknown, $sProtein) || !$sProtein) {
            // unknown variant
            $aCounts['unknown'] += $nCount;
        } elseif (preg_match($sFraShift, $sProtein) || preg_match($sFra2Shift, $sProtein)) {
            // frame shift variant
            $aCounts['fs'] += $nCount;
        } elseif (preg_match($sNoStop, $sProtein)) {
            // no stop variant
            $aCounts['p.X'] += $nCount;
        } elseif (preg_match($sNonsense, $sProtein)) {
            // nonsense variant
            $aCounts['X'] += $nCount;
        } elseif (preg_match($sDelIns, $sProtein)) {
            // variant is an indel
            $aCounts['delins'] += $nCount;
        } elseif (preg_match($sDel, $sProtein)) {
            // variant is an deletion
            $aCounts['del'] += $nCount;
        } elseif (preg_match($sDup, $sProtein)) {
            // variant is an duplication
            $aCounts['dup'] += $nCount;
        } elseif (preg_match($sIns, $sProtein)) {
            // variant is an insertion
            $aCounts['ins'] += $nCount;
        } elseif (preg_match($sNoTransl, $sProtein)) {
            // a no translation variant
            $aCounts['p.0'] += $nCount;
        } elseif (preg_match($sTransInit, $sProtein)) {
            // a translation initiation variant
            $aCounts['p.Met'] += $nCount;
        } elseif (preg_match($sProtSub, $sProtein)) {
            // variant is an substitution
            $aCounts['sub'] += $nCount;
        } elseif (preg_match($sSilent, $sProtein)) {
            // a silent variant
            $aCounts['='] += $nCount;
        } else {
            //a complex variant
            $aCounts['complex'] += $nCount;
        }
    }

    // After fetching and counting data, print it to the screen.
    // Print percentages in horizontal bars
    print('      <SPAN class="S15"><B>Protein variants</B></SPAN><BR>' . "\n" .
          '      <TABLE border="1">' . "\n" .
          '        <TR>' . "\n" .
          '          <TH>variant</TH>' . "\n" .
          '          <TH>number</TH>' . "\n" .
          '          <TH>percentages</TH></TR>' . "\n");
    foreach ($aCounts as $variant => $number) {
        $sPercentage = round(($aCounts[$variant] ? $aCounts[$variant] : 0)/array_sum($aCounts)*100, 2) . '%';
        print('        <TR>' . "\n" .
              '          <TD>' . $aVariants[$variant] . '</TD>' . "\n" .
              '          <TD>' . $aCounts[$variant] . '</TD>' . "\n" .
              '          <TD><IMG src="' . ROOT_PATH . 'gfx/lovd_summ_red.png" alt="' . $sPercentage . '" title="' . $sPercentage . '" width="' . round(($aCounts[$variant] ? $aCounts[$variant] : 0)/array_sum($aCounts)*$nBarWidth) . '" height="15"></TD></TR>' . "\n");
    }
    // Totals row
    print('        <TR>' . "\n" .
          '          <TD>totals</TD>' . "\n" .
          '          <TD>' . array_sum($aCounts) . '</TD>' . "\n" .
          '          <TD><IMG src="' . ROOT_PATH . 'gfx/lovd_summ_red.png" alt="100%" title="100%" width="' . $nBarWidth . '" height="15"></TD></TR></TABLE><BR>' . "\n\n\n\n");
}

lovd_printGeneFooter();
require ROOT_PATH . 'inc-bot.php';
?>
