<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2007-01-23
 * Modified    : 2009-02-02
 * For LOVD    : 2.0-15
 *
 * Access      : Public
 * Purpose     : Declare LOVD functions needed for the columns pages.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *               Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

function lovd_describeFormType ($zData) {
    // Returns sensible form type information based on form type code.

    if (!is_array($zData) || empty($zData['form_type']) || substr_count($zData['form_type'], '|') < 2) {
        return false;
    }

    $aFormType = explode('|', $zData['form_type']);
    $sFormType = ucfirst($aFormType[1]);
    switch ($aFormType[1]) {
        case 'text':
        case 'password':
            $sFormType .= ' (' . $aFormType[2] . ' chars)';
            break;
        case 'textarea':
            $sFormType .= ' (' . $aFormType[2] . ' cols, ' . $aFormType[3] . ' rows)';
            break;
        case 'select':
            $nOptions = substr_count($zData['select_options'], "\r\n") + 1;
            if ($nOptions) {
                $sFormType .= ' (' . ($aFormType[4] == 'true'? 'multiple; ' : '') . $nOptions . ' option' . ($nOptions == 1? '' : 's') . ')';
            }
            break;
    }

    return $sFormType;
}





function lovd_getColumnLength ($sTable, $sCol)
{
    // Determines the column lengths for a given table and column.
    static $aTableCols = array();

    if (empty($aTableCols[$sTable])) {
        $q = mysql_query('SHOW COLUMNS FROM ' . $sTable);
        $aTableCols[$sTable] = array();
        while ($z = @mysql_fetch_assoc($q)) {
            $aTableCols[$sTable][$z['Field']] = $z['Type'];
        }
    }

    $sColType = $aTableCols[$sTable][$sCol];

    if (preg_match('/^((TINY|SMALL|MEDIUM|BIG)?INT|(VAR)?CHAR)\(([0-9]+)\)/i', $sColType, $aRegs) && is_numeric($aRegs[4])) {
        return $aRegs[4];

    } elseif (preg_match('/^DEC\(([0-9]+),([0-9]+)\)/i', $sColType, $aRegs) && is_numeric($aRegs[1]) && is_numeric($aRegs[2])) {
        return ($aRegs[1] + 1);

    } elseif (preg_match('/^(TINY|MEDIUM|LONG)?(TEXT|BLOB)/i', $sColType, $aRegs)) {
        switch ($aRegs[1]) {
            case 'TINY':
                return 256; // 2^8; 1 byte
            case 'MEDIUM':
                return 16777216; // 2^24; 3 bytes
            case 'LONG':
                return 4294967296; // 2^32; 4 bytes
            default:
                return 65536; // 2^16; 2 bytes
        }
    }

    return 0;
}





function lovd_getColumnType ($sTable, $sCol)
{
    // Determines the column type for a given table and column.
    static $aTableCols = array();

    if (empty($aTableCols[$sTable])) {
        $q = mysql_query('SHOW COLUMNS FROM ' . $sTable);
        $aTableCols[$sTable] = array();
        while ($z = @mysql_fetch_assoc($q)) {
            $aTableCols[$sTable][$z['Field']] = $z['Type'];
        }
    }

    $sColType = $aTableCols[$sTable][$sCol];

    if (preg_match('/^((VAR)?CHAR\([0-9]+\)|(TINY|MEDIUM|LONG)?(TEXT|BLOB))/i', $sColType)) {
        return 'CHAR';
    } elseif (preg_match('/^(TINY|SMALL|MEDIUM|BIG)?INT\([0-9]+\)/i', $sColType)) {
        return 'INT';
    } elseif (preg_match('/^DEC\([0-9]+,[0-9]+\)/i', $sColType)) {
        return 'DEC';
    } elseif (preg_match('/^DATETIME/i', $sColType)) {
        return 'DATETIME';
    } elseif (preg_match('/^DATE/i', $sColType)) {
        return 'DATE';
    }
    return false;
}
?>