<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-09-15
 * Modified    : 2009-02-05
 * For LOVD    : 2.0-12
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>Updating LOVD</H3>

            At least once every month, a new LOVD build is released. Currently, this is at the first Monday of the month. An update may contain bug fixes, new features, new custom columns, module updates and such. Therefor, each update has a priority setting to indicate how important it is to update your LOVD installation to the new release.<BR>
            <BR>

            Depending on whether or not LOVD has found that there is an update available, an update icon appears at the bottom right-hand side of the screen:<BR>
            <TABLE border="0" cellpadding="0" cellspacing="0">
              <TR>
                <TD><IMG src="<?php echo ROOT_PATH; ?>gfx/lovd_update_newer.png" alt="green" width="32" height="32"></TD>
                <TD>&nbsp;&nbsp;There is an update available.</TD></TR>
              <TR>
                <TD><IMG src="<?php echo ROOT_PATH; ?>gfx/lovd_update_newest.png" alt="red" width="32" height="32"></TD>
                <TD>&nbsp;&nbsp;There is no update available.</TD></TR>
              <TR>
                <TD><IMG src="<?php echo ROOT_PATH; ?>gfx/lovd_update_error.png" alt="error" width="32" height="32"></TD>
                <TD>&nbsp;&nbsp;There was an error while checking for updates.</TD></TR></TABLE>
            <BR>

            If you are logged in as an authorized user, you can click the update notification icon for more information on the status of the update. If an update is available, detailed information is presented:<BR>
            <B>Last checked for updates</B>: Shows the date LOVD last checked for a new update.<BR>
            <B>Latest version</B>: Shows the detected update.<BR>
            <B>Release date</B>: The date this update has been released.<BR>
            <B>Priority level</B>: Shows how important the LOVD developers consider this update. Can contain 'Optional', 'Common', 'Suggested', 'Recommended', '<SPAN style="color:red;">Important</SPAN>' or '<SPAN style="color:red;"><B>Critical</B></SPAN>', with increasing priority.<BR>
            <B>Release info</B>: Information on the changes that have been done in this release. Please note that this is usually only a very short list of updates. A more elaborate description can always be found in the <A href="http://www.LOVD.nl/2.0/news.php" target="_blank">news section</A> of the LOVD website, and the full list can be found in the <A href="http://www.LOVD.nl/2.0/changelog.txt" target="_blank">LOVD changelog</A>.<BR>
            <BR>

            <B>If you choose to upgrade LOVD, follow these steps:</B><BR>
            <OL style="margin : 0px;">
              <LI><B>Download the new build.</B> Either using the direct link to it from the update window, or from the website.</LI>
              <LI><B>Unpack the new build</B> and overwrite the LOVD files.</LI>
              <LI>If you're working from your local machine, <B>upload the updated files</B> to your webserver.</LI>
              <LI><B>Log into LOVD.</B> This is an important step. If you are already logged in, perform some activity, like clicking on the Home tab. LOVD will then upgrade the database tables to make sure the database backend has the same version as the files. Skipping this step may result in serious errors occurring.</LI>
              <LI><B>You're done!</B></LI>
            </OL>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
