<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-23
 * Modified    : 2008-12-05
 * For LOVD    : 2.0-13
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>Variant and patient data</H3>
            <H4>Submitting variant and patient data</H4>

            Unlike LOVD 1.1.0, both submitters and curators now use the same submission form to submit variant and patient data. The differences between submitting as a curator compared to submitting as a submitter:<BR>
            <UL style="margin : 0px;">
              <LI>Curators can also fill in non-public fields</LI>
              <LI>Curators can directly publish the variant entries</LI>
              <LI>Curators can directly assign a submitter to the patient entry</LI>
            </UL>
            <BR>

            Since in LOVD 2.0 variant data has been split from patient data, the submission is now a multi-step process where variant data is entered separately from the patient data. To start the submission process, click the "Submit" tab. You'll need to be logged in to start the submission process.<BR>
            <BR>

            The first step of the submission process is to select the gene the variant you are about the enter, is found in. Select the gene you're submitting to and click the "Select gene database" link. You're shown the submission overview, where you can see the data you entered. Currently, it's empty. Whether you start with adding variant or patient information, does not matter.<BR>
            <BR>

            <H5>Adding variant data</H5>

            It's easy to check if the variant you're about to enter, already exists in the database. Just click the "Using an existing variant &raquo;" button in the "Sequence variant data" section. This will open a pop-up where you can enter the variant name (i.e. 'c.11G>A'). The field will autocomplete your input. You can also double click on the field, and it will show you a list of variants already in the database (if any). After you filled in or selected the variant's name, press "Review variant data". If the variant already existed, the variant submission form is filled in for you. Review all fields and click "Add variant data" when you're done.<BR>
            <BR>

            If the variant is not in the database yet, just click the "Add variant data &raquo;" button on the submission overview and you'll get an empty variant submission form that you can fill out. Once you're done, click the "Add variant data" button and you'll be forwarded back to the submission overview.<BR>
            <BR>

<?php
lovd_showInfoTable('If you want to submit a homozygous mutation, you only have to fill in the variant form once. Just select "Both (homozygous)" for the "Variant allele" field and LOVD will create two variant entries for you.', 'information');
?>

            Once you've added variant data to your submission it'll show up in the submission overview. You can keep adding variant data until you're done. If you want to add variant data from a different gene, first complete this submission and then add those other variants to your patient entry in a new submission process.<BR>
            You can also remove added variant data by clicking the small red mark at the right side of the variant entry.<BR>
            <BR>

            <H5>Adding patient data</H5>

            You can add only one patient per submission. If you want to add one or more variants to an existing patient, you'll need the patient's internal reference ID. You can find it in the header of the patient data table in the detailed view, or you can just click the "Add new variant to patient" link below the patient data table in the detailed view, which will forward you into the submission process, and will fill in the patient information for you.<BR>
            <BR>

            For adding a new patient, use the "Add new patient data &raquo;" button, and fill out the patient data submission form.<BR>
            <BR>

            <H5>Finalize submission</H5>

            Once you have the patient data filled in and have added at least one variant, the "Finalize submission" button will be enabled. Once you click this button, the data will be stored in the database and the curator(s) and you will receive a copy of your submission through email. If you are a submitter, your submission will be public once the curator publishes (curates) your findings.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
