<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-08-08
 * Modified    : 2009-03-03
 * For LOVD    : 2.0-17
 *
 * Access      : Public
 * Purpose     : View & search selected gene's variants.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// If no gene selected, forward to the select list.
if (!$_SESSION['currdb']) {
    header('Location: ' . PROTOCOL . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/home.php' . lovd_showSID());
    exit;
}





if (in_array($_GET['action'], array('view_all', 'search_all', 'view_unique', 'search_unique'))) {
    // View all / search variants in this gene.

    // 2008-02-15; 2.0-04; Allow others to hide columns for this session only.
    // 2008-09-17; 2.0-12; Store this information in a cookie, so that it will be remembered after your session ends.
    if (isset($_COOKIE[$_SETT['cookie_id'] . '_hidden_cols'])) {
        $aHiddenColumns = explode(';', $_COOKIE[$_SETT['cookie_id'] . '_hidden_cols']);
    } else {
        $aHiddenColumns = array();
    }
    if (!empty($_GET['hide_col'])) {
        if (is_array($_GET['hide_col'])) {
            foreach ($_GET['hide_col'] as $sCol) {
                // We don't check the availability of the column here, because some other gene may have it.
                if (!in_array($sCol, $aHiddenColumns)) {
                    $aHiddenColumns[] = $sCol;
                }
            }
        } elseif (is_string($_GET['hide_col'])) {
            if (!in_array($_GET['hide_col'], $aHiddenColumns)) {
                $aHiddenColumns[] = $_GET['hide_col'];
            }
        }
    }
    if (!empty($_GET['show_col'])) {
        if (is_array($_GET['show_col'])) {
            foreach ($_GET['show_col'] as $sCol) {
                $nKey = array_search($sCol, $aHiddenColumns);
                if ($nKey !== false) {
                    unset($aHiddenColumns[$nKey]);
                }
            }
        } elseif (is_string($_GET['show_col'])) {
            $nKey = array_search($_GET['show_col'], $aHiddenColumns);
            if ($nKey !== false) {
                unset($aHiddenColumns[$nKey]);
            } elseif ($_GET['show_col'] == 'all') {
                $aHiddenColumns = array();
            }
        }
    }

    // Now, store the settings in the cookie.
    if ((!isset($_COOKIE[$_SETT['cookie_id'] . '_hidden_cols']) && count($aHiddenColumns)) || (isset($_COOKIE[$_SETT['cookie_id'] . '_hidden_cols']) && $_COOKIE[$_SETT['cookie_id'] . '_hidden_cols'] != $aHiddenColumns)) {
        setcookie($_SETT['cookie_id'] . '_hidden_cols', implode(';', $aHiddenColumns), time() + 60*60*24*31);
    }

    // Whether or not a user can see non-public data.
    define('IS_CURATOR', lovd_isCurator($_SESSION['currdb']));

    require ROOT_PATH . 'inc-lib-list.php';
    require ROOT_PATH . 'class/currdb.php';
    $_CURRDB = new CurrDB();
    $_CURRDB->hideCols('public', IS_CURATOR);
    $_CURRDB->hideColsByTable((substr($_GET['action'], -6) == 'unique'? 'Variant' : ''));
    require ROOT_PATH . 'inc-top.php';
    lovd_printGeneHeader();
    lovd_printHeader('variant_listings', 'LOVD - Variant listings for ' . $_SESSION['currdb']);

    // 2007-03-20; 2.0-alpha-09; Isn't *not* joining to TABLE_PATIENTS much faster? Joining prevents orphaned entries to show up.
    //list($nTotal) = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_PAT2VAR . ' AS t1 LEFT JOIN ' . TABLE_PATIENTS . ' AS t2 USING (patientid) WHERE t1.symbol = "' . $_SESSION['currdb'] . '" AND ' . (IS_CURATOR? '1=1' : 't1.status >= ' . STATUS_MARKED)));
    list($nTotal) = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_PAT2VAR . ' AS t1 WHERE t1.symbol = "' . $_SESSION['currdb'] . '" AND ' . (IS_CURATOR? '1=1' : 't1.status >= ' . STATUS_MARKED)));
    if (!$nTotal) {
        print('      There are currently no ' . (IS_CURATOR? '' : 'public ') . 'variants in this gene.<BR>' . "\n");
        lovd_printGeneFooter();
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Standard query, will be extended later on.
    if (substr($_GET['action'], -6) == 'unique') {
        // View unique. View all variants, exclude non public entries depending on $_CONF['hide_nonpublic'].
        $sQ = 'SELECT v.*, count(p2v.variantid) AS mutations FROM ' . TABLE_CURRDB_VARS . ' AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (p2v.symbol = "' . $_SESSION['currdb'] . '" AND v.variantid = p2v.variantid) LEFT OUTER JOIN ' . TABLE_PATHOGENIC . ' AS path USING (pathogenic) WHERE ' . (!IS_CURATOR && $_CONF['hide_nonpublic']? 'p2v.status >= ' . STATUS_MARKED : '1=1');
    } else {
        // View all.
        $sQ = 'SELECT v.*, p.*, p2v.allele, p2v.status' . (IS_CURATOR? ', stat.status_text AS status_' : '') . ', path.pathogenic_text AS pathogenic_, count(p2v_2.variantid) AS mutations, s.reference AS subs_reference FROM ' . TABLE_CURRDB_VARS . ' AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (p2v.symbol = "' . $_SESSION['currdb'] . '" AND v.variantid = p2v.variantid) LEFT JOIN ' . TABLE_PATIENTS . ' AS p USING (patientid) LEFT OUTER JOIN ' . TABLE_PAT2VAR . ' AS p2v_2 ON (p.patientid = p2v_2.patientid' . (IS_CURATOR? '' : ' AND p2v_2.status >= ' . STATUS_MARKED) . ')' . (IS_CURATOR? ' LEFT OUTER JOIN ' . TABLE_VAR_STATUS . ' AS stat ON (p2v.status = stat.status)' : '') . ' LEFT OUTER JOIN ' . TABLE_PATHOGENIC . ' AS path ON (p2v.pathogenic = path.pathogenic) LEFT OUTER JOIN ' . TABLE_SUBS . ' AS s ON (p.submitterid = s.submitterid) WHERE ' . (IS_CURATOR? '1=1' : 'p2v.status >= ' . STATUS_MARKED . ' AND p2v_2.status >= ' . STATUS_MARKED);
    }

    // Guess the column used to describe the mutation.
    $sMutationCol = $_CURRDB->getMutationCol();

    if (substr($_GET['action'], 0, 6) == 'search') {
        // Here starts the actual building of the query.

        // 2008-07-31; 2.0-10; Implement XSS check on search terms.
        foreach ($_GET as $key => $val) {
            if (!is_array($val) && $val != strip_tags($val)) {
                $_GET[$key] = '';
            }
        }

        // SEARCH: Exception for $_GET['search_MutCol'].
        if (!empty($_GET['search_MutCol'])) {
            if (!empty($_GET['search_' . $sMutationCol])) {
                $_GET['search_' . $sMutationCol] .= ' ' . $_GET['search_MutCol'];
            } else {
                $_GET['search_' . $sMutationCol] = $_GET['search_MutCol'];
            }
        }

        // SEARCH: Advanced text search.
        $aSearchText = array_merge(
                 array('search_pathogenic_' => 'path.pathogenic_text'),
                 $_CURRDB->buildSearchList());
        if (IS_CURATOR) {
            // Add status.
            $aSearchText['search_submitterid'] = 'p.submitterid';
            $aSearchText['search_status_'] = 'stat.status_text';
        }
        foreach ($aSearchText as $key => $val) {
            if (isset($_GET[$key]) && trim($_GET[$key])) {
                $a = explode(' ', trim($_GET[$key]));
                foreach ($a as $sTerm) {
                    if ($sTerm) {
                        if (substr_count($sTerm, '|') && preg_match('/^[^|]+(\|[^|]+)+$/', $sTerm)) {
                            // OR.
                            $aOR = explode('|', $sTerm);
                            $sQ .= ' AND (';
                            foreach ($aOR as $nTerm => $sTerm) {
                                // 2009-03-03; 2.0-17; Advanced searching did not allow to combine NOT and OR searches.
                                if (substr($sTerm, 0, 1) == '!') {
                                    // NOT.
                                    $sQ .= ($nTerm? ' OR ' : '') . $val . ' NOT LIKE "%' . lovd_escapeSearchTerm(substr($sTerm, 1)) . '%"';
                                } else {
                                    // Common search term.
                                    $sQ .= ($nTerm? ' OR ' : '') . $val . ' LIKE "%' . lovd_escapeSearchTerm($sTerm) . '%"';
                                }
                            }
                            $sQ .= ')';
                        } elseif (substr($sTerm, 0, 1) == '!') {
                            // NOT.
                            $sQ .= ' AND ' . $val . ' NOT LIKE "%' . lovd_escapeSearchTerm(substr($sTerm, 1)) . '%"';
                        } else {
                            // Common search term.
                            $sQ .= ' AND ' . $val . ' LIKE "%' . lovd_escapeSearchTerm($sTerm) . '%"';
                        }
                    }
                }
            }
        }
    }

    if (substr($_GET['action'], -6) == 'unique') {
        $sQ .= ' GROUP BY v.`' . $sMutationCol . '`';
    } else {
        // Add p2v.allele here to show homozygous mutations twice in the list.
        $sQ .= ' GROUP BY v.variantid, p.patientid';
    }

    $nResults = mysql_num_rows(mysql_query($sQ));

    // SORT: Current settings.
    if (!empty($_GET['order'])) {
        $aOrder = explode(',', $_GET['order']);
    } else {
        $aOrder = array('', '');
    }

    // SORT: Column data.
    $aOrderList = array_merge(
             array('pathogenic_' => array('path.pathogenic', 'ASC')),
             array('sort' => array('v.sort', 'ASC')),
             $_CURRDB->buildOrderList());
    if (substr($_GET['action'], -3) == 'all' && IS_CURATOR) {
        // Add submitterid & status.
        $aOrderList['submitterid'] = array('p.submitterid', 'ASC');
        $aOrderList['status_'] = array('p2v.status', 'ASC');
    }
    if (!array_key_exists($aOrder[0], $aOrderList)) {
        // 2007-10-10; 2.0-beta-10; Changed default sorting column from Exon to Variant/DNA.
        $aOrder[0] = $sMutationCol;
    }
    if ($aOrder[1] != 'ASC' && $aOrder[1] != 'DESC') {
        $aOrder[1] = $aOrderList[$aOrder[0]][1];
    }

    // 2007-10-10; 2.0-beta-10; Fixed bug #18 - Variants do not sort correctly when selecting DNA column to sort on.
    // SORT: Additional sort columns (faking a perfect sort).
    $sOrderPre = '';
    $sOrderPost = '';
    if (in_array($aOrder[0], array('Variant/DNA', 'Variant/Exon'))) {
        // 1) In case of the mutation column, sort FIRST on Exon, and sort.
        if ($_CURRDB->colExists('Variant/Exon')) {
            $sOrderPre .= 'v.`Variant/Exon` ' . $aOrder[1] . ', ';
        }
        $sOrderPre .= 'v.sort ' . $aOrder[1] . ', ';
    } else {
        // 2) In case of anything else, sort on Exon, and sort AFTER.
        if ($_CURRDB->colExists('Variant/Exon')) {
            $sOrderPost .= ', v.`Variant/Exon` ' . $aOrder[1];
        }
        $sOrderPost .= ', v.sort ' . $aOrder[1];
    }

    $_GET['limit'] = (isset($_GET['limit']) && in_array($_GET['limit'], $_SETT['variant_listsizes'])? $_GET['limit'] : (HAS_AUTH? $_AUTH['list_size'] : 100));
    $sQueryLimit = lovd_pagesplitInit(($nResults > 0? $nResults : $nTotal), $_GET['limit']);
    $sQ .= ' ORDER BY ' . $sOrderPre . $aOrderList[$aOrder[0]][0] . ' ' . $aOrder[1] . $sOrderPost . (substr($_GET['action'], -6) == 'unique'? '' : ', p.patientid') . ' ' . $sQueryLimit;



    // Show form; required for sorting and searching.
    // 2008-02-15; 2.0-04; Allow form to store info for hiding/showing columns.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '" method="get" style="margin : 0px;">' . "\n" .
          '        <INPUT type="hidden" name="select_db" value="' . $_SESSION['currdb'] . '">' . "\n" .
          '        <INPUT type="hidden" name="action" value="' . $_GET['action'] . '">' . "\n" .
          '        <INPUT type="hidden" name="order" value="' . implode(',', $aOrder) . '">' . "\n" .
          '        <INPUT type="hidden" name="hide_col" value="">' . "\n" .
          '        <INPUT type="hidden" name="show_col" value="">' . "\n\n");

    if (!$nResults) {
        // FIXME; this is not how it should be done. There's supposed to be some link here, showing all variants again.
        //     What about returning to the previous search results? Store in $_SESSION?
        // Searched, but no results.
        print('      No results have been found that match your criteria.<BR><BR>' . "\n\n");
        if (!IS_CURATOR && !empty($_GET['search_' . $sMutationCol])) {
            // Possibly, visitor is searching for variant that is not public. Isolate basepair and actually check.
            $sBase = preg_replace('/^(c\.|g\.)?([[(?]*)/', "$1", $_GET['search_' . $sMutationCol]);
            $sBase = preg_replace('/^((c\.|g\.)?\*?\-?[0-9]+([-+][0-9]+)?(_[0-9]+([-+][0-9]+)?)?).*/', "$1", $sBase);

            $sQ = 'SELECT COUNT(*) FROM ' . TABLE_CURRDB_VARS . ' AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (p2v.symbol = "' . $_SESSION['currdb'] . '" AND v.variantid = p2v.variantid) WHERE v.`' . $sMutationCol . '` LIKE "' . $sBase . '%" AND p2v.status < ' . STATUS_MARKED;
            list($nResults) = mysql_fetch_row(mysql_query($sQ));
            if ($nResults) {
                print('      A variant for ' . $sBase . ' is present in our database but it is not yet public. When you want more information, please contact the curator, specifying the variant you are looking for. When you have identified this variant in a sample, please submit it right away; only a complete and fully up-to-date database is most useful for those interested.<BR><BR>' . "\n\n");
            } else {
                print('      Possibly, you\'re looking for an entry that is not yet public. If so, contact the curator for information about the variant you\'re looking for.<BR><BR>' . "\n\n");
            }
        }
        lovd_printGeneFooter();
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    $q = mysql_query($sQ);
    if (!$q) {
        lovd_dbFout('Variants' . ucfirst($_GET['action']), $sQ, mysql_error());
    }

    if ($_GET['action'] == 'search_unique' && !empty($_GET['search_pathogenic_']) && $_GET['search_pathogenic_'] == '-') {
        // 'Polymorphism' table.
        lovd_showInfoTable('Please note that this overview may not be complete, as variants with unknown effect to the phenotype are left out.', 'warning');
    }

    // 2008-10-01; 2.0-13; Show "Unhide all columns" button.
    if (count($aHiddenColumns)) {
        lovd_viewNavigation('<A href="#" onclick="document.forms[0].show_col.value=\'all\';document.forms[0].submit();">Unhide all columns</A>');
        print('      <BR>' . "\n\n");
    }

    $n = (isset($nResults)? $nResults : $nTotal);
    print('      <SPAN class="S11">' . $n . (substr($_GET['action'], -6) == 'unique' || IS_CURATOR? '' : ' public') . ' entr' . ($n == 1? 'y' : 'ies') . '</SPAN><BR>' . "\n");

    // Array which will make up the table (header and data).
    if (substr($_GET['action'], -3) == 'all') {
        $aTable = array('pathogenic_' => array('Path.', 50));
    } else {
        $aTable = array();
    }
    $aTable = array_merge($aTable, $_CURRDB->buildTable('list'));

    // Additional columns for authorized users.
    if (substr($_GET['action'], -3) == 'all' && IS_CURATOR) {
        $aTable['submitterid'] = array('Submitterid', 100);
        $aTable['status_'] = array('Status', 75);
    }

    // Stretch it up, cause we're adding data to it...
    if ($aTable[$sMutationCol][1] < 200) {
        $aTable[$sMutationCol][1] = 200;
    }

    // Total width.
    $nTotalWidth = 2;
    $nHiddenColWidth = 5;
    foreach ($aTable as $sCol => $aCol) {
        // 2008-02-15; 2.0-04; Hidden columns are smaller!
        if (in_array($sCol, $aHiddenColumns) && $sCol != $sMutationCol) {
            // We don't allow the MutationCol to be hidden!
            $nTotalWidth += $nHiddenColWidth + 8;
        } else {
            $nTotalWidth += $aCol[1] + 8;
        }
    }



    // Print selection list to choose amount or results per page.
    print('      <SPAN class="S11"><SELECT name="limit" class="S11" onchange="document.forms[0].submit();">');
    foreach ($_SETT['variant_listsizes'] as $nSize) {
        print("\n" . 
              '        <OPTION value="' . $nSize . '"' . ($_GET['limit'] == $nSize? ' selected' : '') . '>' . $nSize . '</OPTION>');
    }
    print('</SELECT> entries per page</SPAN><BR>' . "\n\n");

    // Stretch table up, to respect column widths.
    print('      <IMG src="' . ROOT_PATH . 'gfx/trans.png" alt="" width="' . $nTotalWidth . '" height="1"><BR>' . "\n\n");

    // Table.
    print('      <TABLE border="0" cellpadding="0" cellspacing="1" class="data">' . "\n" .
          '        <TR>');

    foreach ($aTable as $sField => $aCol) {
        // 2008-02-15; 2.0-04; Hide columns!
        if (in_array($sField, $aHiddenColumns) && $sField != $sMutationCol) {
            // We don't allow the MutationCol to be hidden!
            print("\n" . '          <TH width="' . $nHiddenColWidth . '"><A href="#" onclick="document.forms[0].show_col.value=\'' . $sField . '\';document.forms[0].submit();"><IMG src="' . ROOT_PATH . 'gfx/order_arrow_show.png" alt="Unhide ' . $aCol[0] . ' column" title="Unhide ' . $aCol[0] . ' column" width="5" height="13" border="0"></A></TH>');
            continue;
        }

        // Location onclick changed because of the search fields within the same <TH>. Clicking on the field triggers a sort.
        print("\n" . '          <TH valign="top"' . (!empty($aCol[2])? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . (array_key_exists($sField, $aOrderList)? ' class="order' . ($aOrder[0] == $sField? 'ed' : '') . '"' : '') . '>' .
              (array_key_exists($sField, $aOrderList)? "\n" .
                                                           '            <TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="S11">' . "\n" .
                                                           '              <TR' . (array_key_exists($sField, $aOrderList)? ' onclick="document.forms[0].order.value=\'' . $sField . ',' . ($aOrder[0] == $sField? ($aOrder[1] == 'ASC'? 'DESC' : 'ASC') : $aOrderList[$sField][1]) . '\';document.forms[0].submit();"' : '') . '>' . "\n" .
                                                           '                <TH>' . str_replace(' ', '&nbsp;', $aCol[0]) . '</TH>' . "\n" .
                                                           '                <TD align="right" width="13">' . ($sField == $sMutationCol? '&nbsp;' : '<IMG src="' . ROOT_PATH . 'gfx/order_arrow_hide.png" alt="Hide ' . $aCol[0] . ' column" title="Hide ' . $aCol[0] . ' column" width="11" height="11" onclick="document.forms[0].hide_col.value=\'' . $sField . '\';document.forms[0].submit();" style="margin : 1px;">') . '</TD>' . "\n" .
                                                           '                <TD align="right" width="13"><IMG src="' . ROOT_PATH . 'gfx/order_arrow_desc' . ($aOrder[0] == $sField && $aOrder[1] == 'DESC'? '_sel' : '') . '.png" alt="Descending" title="Descending" width="13" height="6"><BR><IMG src="' . ROOT_PATH . 'gfx/order_arrow_asc' . ($aOrder[0] == $sField && $aOrder[1] == 'ASC'? '_sel' : '') . '.png" alt="Ascending" title="Ascending" width="13" height="6"></TD></TR>' .
                                                           (substr($_GET['action'], 0, 6) == 'search'? "\n" .
                                                                                         '              <TR>' . "\n" .
                                                                                         '                <TD colspan="3"><INPUT type="text" name="search_' . $sField . '" value="' . (isset($_GET['search_' . $sField])? $_GET['search_' . $sField] : '') . '" title="' . $aCol[0] . ' field should contain..." style="width : ' . ($aCol[1] - 8) . 'px; font-weight : normal;" onchange="document.forms[0].submit();"></TD></TR>' : '') .
                                                           '</TABLE>' : $aCol[0]) . '</TH>');
    }
    print('</TR>');

    $i = 0;
    $nRepeat = 25;
    while ($zData = mysql_fetch_assoc($q)) {
        // Print header repeatedly.
        $i ++;
        if (!($i%($nRepeat+1))) {
            print("\n" .
                  '        <TR>');
            foreach ($aTable as $sField => $aCol) {
                // 2008-02-15; 2.0-04; Hide columns!
                if (in_array($sField, $aHiddenColumns) && $sField != $sMutationCol) {
                    // We don't allow the MutationCol to be hidden!
                    print("\n" . '          <TH width="' . $nHiddenColWidth . '"><A href="#" onclick="document.forms[0].show_col.value=\'' . $sField . '\';document.forms[0].submit();"><IMG src="' . ROOT_PATH . 'gfx/order_arrow_show.png" alt="Unhide ' . $aCol[0] . ' column" title="Unhide ' . $aCol[0] . ' column" width="5" height="13" border="0"></A></TH>');
                    continue;
                }

                print("\n" . '          <TH valign="top"' . (!empty($aCol[2])? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . (array_key_exists($sField, $aOrderList)? ' class="order' . ($aOrder[0] == $sField? 'ed' : '') . '"' : '') . '>' .
                      (array_key_exists($sField, $aOrderList)? "\n" .
                                                                   '            <TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="S11">' . "\n" .
                                                                   '              <TR' . (array_key_exists($sField, $aOrderList)? ' onclick="document.forms[0].order.value=\'' . $sField . ',' . ($aOrder[0] == $sField? ($aOrder[1] == 'ASC'? 'DESC' : 'ASC') : $aOrderList[$sField][1]) . '\';document.forms[0].submit();"' : '') . '>' . "\n" .
                                                                   '                <TH>' . str_replace(' ', '&nbsp;', $aCol[0]) . '</TH>' . "\n" .
                                                                   '                <TD align="right" width="13">' . ($sField == $sMutationCol? '&nbsp;' : '<IMG src="' . ROOT_PATH . 'gfx/order_arrow_hide.png" alt="Hide ' . $aCol[0] . ' column" title="Hide ' . $aCol[0] . ' column" width="11" height="11" onclick="document.forms[0].hide_col.value=\'' . $sField . '\';document.forms[0].submit();" style="margin : 1px;">') . '</TD>' . "\n" .
                                                                   '                <TD align="right" width="13"><IMG src="' . ROOT_PATH . 'gfx/order_arrow_desc' . ($aOrder[0] == $sField && $aOrder[1] == 'DESC'? '_sel' : '') . '.png" alt="Descending" title="Descending" width="13" height="6"><BR><IMG src="' . ROOT_PATH . 'gfx/order_arrow_asc' . ($aOrder[0] == $sField && $aOrder[1] == 'ASC'? '_sel' : '') . '.png" alt="Ascending" title="Ascending" width="13" height="6"></TD></TR>' .
                                                                   '</TABLE>' : $aCol[0]) . '</TH>');
            }
            print('</TR>');
            $i = 1;
        }

        if (substr($_GET['action'], -6) == 'unique') {
            // Unique list is slightly simpler.
            print("\n" .
                  '        <TR valign="top" style="cursor : pointer; cursor : hand;" onmouseover="this.className = \'hover\';" onmouseout="this.className = \'\';" onclick="window.location.href = \'' . $_SERVER['PHP_SELF'] . '?select_db=' . $_SESSION['currdb'] . '&amp;action=search_all&amp;search_' . rawurlencode($sMutationCol) . '=' . rawurlencode($zData[$sMutationCol]) . lovd_showSID(true, true) . '\';">');
        } else {
            print("\n" .
                  '        <TR valign="top"' . (IS_CURATOR && $zData['status'] < STATUS_OK? ' class="' . ($zData['status'] < STATUS_MARKED? 'del' : 'marked') . '"' : '') . ' style="cursor : pointer; cursor : hand;" onmouseover="this.className = \'' . (IS_CURATOR && $zData['status'] < STATUS_OK? ($zData['status'] < STATUS_MARKED? 'del_' : 'marked_') : '') . 'hover\';" onmouseout="this.className = \'' . (IS_CURATOR && $zData['status'] < STATUS_OK? ($zData['status'] < STATUS_MARKED? 'del' : 'marked') : '') . '\';" onclick="window.location.href = \'' . $_SERVER['PHP_SELF'] . '?select_db=' . $_SESSION['currdb'] . '&amp;action=view&amp;view=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . lovd_showSID(true, true) . '\';">');
        }

        // Create normal anchor link as well.
        if (substr($_GET['action'], -6) == 'unique') {
            $sLink = '<A href="' . $_SERVER['PHP_SELF'] . '?select_db=' . $_SESSION['currdb'] . '&amp;action=search_all&amp;search_' . rawurlencode($sMutationCol) . '=' . rawurlencode($zData[$sMutationCol]) . lovd_showSID(true, true) . '" class="data">';
        } else {
            $sLink = '<A href="' . $_SERVER['PHP_SELF'] . '?select_db=' . $_SESSION['currdb'] . '&amp;action=view&amp;view=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . lovd_showSID(true, true) . '" class="data"' . ($zData['status'] < STATUS_MARKED? ' style="color : #AAAAAA;"' : '') . '>';
        }
        if ($sMutationCol) {
            $zData[$sMutationCol] = $sLink . $zData[$sMutationCol] . '</A>';
        }

        // Very unlikely not to function; only if none of the HGVS standard DNA, RNA or Protein fields are enabled, this will fail.
        if ($zData['mutations'] > 1) {
            if (substr($_GET['action'], -3) == 'all') {
                // 2008-03-27; 2.0-05; Show only a maximum number of other mutations associated with this patient. Otherwise, hide them all.
                if ($zData['mutations'] > 10) {
                    // Too many to fetch; wouldn't look good.
                    // FIXME; make a setting out of this.
                    $zData[$sMutationCol] .= '<BR>&nbsp;&nbsp;&nbsp;&nbsp;+ ' . ($zData['mutations'] - 1) . ' others';
                } else {
                    // Fetch info on other mutations.
                    // FIXME; this may be quite a performance lag with a high $_GET['limit'] value and lots of associated mutations.
                    // Backwards compatible with MySQL 4.0 and earlier; if we rely on MySQL 4.1, we could do a GROUP_CONCAT in top mutation fetch query that save us these queries.
                    $sQOther = 'SELECT p2v.*, v.`' . $sMutationCol . '` FROM ' . TABLE_PAT2VAR . ' AS p2v LEFT OUTER JOIN ' . TABLE_CURRDB_VARS . ' AS v ON (p2v.symbol = "' . $_SESSION['currdb'] . '" AND v.variantid = p2v.variantid) WHERE ' . (IS_CURATOR? '' : 'p2v.status >= ' . STATUS_MARKED . ' AND ') . 'p2v.patientid = "' . $zData['patientid'] . '" AND !(p2v.symbol = "' . $_SESSION['currdb'] . '" AND p2v.variantid = "' . $zData['variantid'] . '" AND p2v.allele = "' . $zData['allele'] . '") ORDER BY ' . ($_CURRDB->colExists('Variant/Exon')? 'v.`Variant/Exon` ASC, ' : '') . 'v.sort ASC';

                    $qOther = mysql_query($sQOther);
                    $sOther = '';
                    $aOther = array();

                    // Loop other variants found in the same patient.
                    while ($zOther = mysql_fetch_assoc($qOther)) {
                        if ($zOther['symbol'] == $_SESSION['currdb']) {
                            // Other variant in same gene.
                            $sOther .= ($sOther? ', ' : '') . $zOther[$sMutationCol];
                        } else {
                            // Other variant in different gene.
                            if (!isset($aOther[$zOther['symbol']])) {
                                $aOther[$zOther['symbol']] = 0;
                            }
                            $aOther[$zOther['symbol']] ++;
                        }
                    }

                    if (count($aOther)) {
                        foreach ($aOther as $sGene => $nOther) {
                            $sOther .= ($sOther? ', ' : '') . $sGene . ' (' . $nOther . ')';
                        }
                    }

                    $zData[$sMutationCol] .= '<BR>&nbsp;&nbsp;&nbsp;&nbsp;+ ' . $sOther;
                }

            } else {
                // Unique variant list, found more than once.
                $zData[$sMutationCol] .= '<BR>&nbsp;&nbsp;(Reported ' . $zData['mutations'] . ' times)';
            }
        }

        // Parse and build Custom Links.
        lovd_buildLinks($zData);

        // Transform select lists' values.
        $_CURRDB->transformSelectValues($zData);

        // FIXME;
        // Shorten strings for TEXT that surely doesn't contain HTML tags... HOW?

        // Submitter reference...
        if ($_CURRDB->colExists('Patient/Reference') && $zData['subs_reference']) {
            // 2008-03-28; 2.0-05; Show full submitter information directly from this link.
            $zData['Patient/Reference'] .= (!empty($zData['Patient/Reference'])? ', ' : '') . '<A href="#" onclick="lovd_openWindow(\'' . ROOT_PATH . 'submitters.php?action=view&amp;view=' . $zData['submitterid'] . lovd_showSID(true, true) . '\', \'SubmitterView\', 400, 175, event.screenX - 50, event.screenY - 50); return false;">' . $zData['subs_reference'] . '</A>';
        }

        // SubmitterID, don't show the '00000' entries.
        if (array_key_exists('submitterid', $aTable) && (int) $zData['submitterid'] == 0) {
            $zData['submitterid'] = 0;
        }

        foreach ($aTable as $sField => $aCol) {
            // 2008-02-15; 2.0-04; Hidden columns are smaller!
            if (in_array($sField, $aHiddenColumns) && $sField != $sMutationCol) {
                // We don't allow the MutationCol to be hidden!
                print("\n" . '          <TD width="' . $nHiddenColWidth . '">&nbsp;</TD>');
                continue;
            }

            print("\n" . '          <TD' . (!empty($aCol[2])? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . ($aOrder[0] == $sField? ' class="ordered"' : '') . '>' . (!$zData[$sField]? '-' : $zData[$sField]) . '</TD>');
        }
        print('</TR>');
    }
    print('</TABLE>' . "\n" .
          '</FORM>' . "\n\n");



    // URL pagelink.
    $sPageLink = 'order=' . rawurlencode(implode(',', $aOrder));

    if (substr($_GET['action'], 0, 6) == 'search') {
        // SEARCH: Simple text search.
        foreach ($aSearchText as $key => $val) {
            if (isset($_GET[$key]) && $_GET[$key]) {
                $sPageLink .= ($sPageLink? '&amp;' : '') . $key . '=' . rawurlencode($_GET[$key]);
            }
        }
    }

    lovd_pagesplitShowNav($sPageLink);

    if ($_SETT['currdb']['allow_download'] || IS_CURATOR) {
        lovd_showInfoTable('Click here to save this list in a tab-delimited text file.', 'save', '500', 'download.php?select_db=' . $_SESSION['currdb'] . '&amp;action=' . $_GET['action'] . '&amp;' . $sPageLink . '');
    }

    // Notes for the variant listings...
    if ($_SETT['currdb']['note_listing']) {
        print(str_replace(array("\r\n", "\r", "\n"), '<BR>', $_SETT['currdb']['note_listing']) . '<BR><BR>' . "\n\n");
    }

    // Short legend...
    print('      <SPAN class="S15"><B>Legend:</B></SPAN> [ <A href="variants_legend.php?select_db=' . $_SESSION['currdb'] . '" target="_blank">' . $_SESSION['currdb'] . ' full legend</A> ]<BR>' . "\n\n" .
          '      <SPAN class="S11">' . "\n" .
          '        Sequence variations are described basically as recommended by the Ad-Hoc Committee for Mutation Nomenclature (AHCMN), with the recently suggested additions (den Dunnen JT and Antonarakis SE [2000], Hum.Mut. 15:7-12); for a summary see <A href="http://www.HGVS.org/mutnomen/"><B>Nomenclature</B></A>.' . "\n" .
          '        ' . ($_SETT['currdb']['refseq']? '<A href="' . $_SETT['currdb']['refseq_url'] . '">' . ($_SETT['currdb']['refseq'] == 'c'? 'Coding DNA ' : ($_SETT['currdb']['refseq'] == 'g'? 'Genomic ' : '')) . 'Reference Sequence</A>' . ($_SETT['currdb']['refseq'] == 'c'? ', with the first base of the Met-codon counted as position 1' : '') . '.' : '') . '<BR>' . "\n" .
          '        ' . (substr($_GET['action'], -6) == 'unique'? '' : '<B>Path.</B>: Variant pathogenicity, in the format Reported/Concluded; \'+\' indicating the variant is pathogenic, \'+?\' probably pathogenic, \'-\' no known pathogenicity, \'-?\' probably no pathogenicity, \'?\' effect unknown. ') . $_CURRDB->buildLegend('short') .
          (substr($_GET['action'], -3) == 'all' && IS_CURATOR? ' <B>Status</B>: Status of this variant entry.' : '') .
          '</SPAN><BR><BR>' . "\n\n");

    lovd_printGeneFooter();
    require ROOT_PATH . 'inc-bot.php';
    exit;





} elseif ($_GET['action'] == 'view' && ((preg_match('/^([0-9]{1,7})\,([0-9]{1,7})(\,([0-9]{1,2}))?$/', $_GET['view'], $aRegs) && list(, $_GET['patientid'], $_GET['variantid']) = $aRegs) || (preg_match('/^([0-9]{1,7})$/', $_GET['view'], $aRegs) && list(, $_GET['patientid']) = $aRegs))) {
    // View specific patient/mutation.

    // 2008-08-28; 2.0-11; When "My Submissions" has been enabled, submitters can now also see their own unpublished variants.
    if (HAS_SUBS && $_CONF['my_submissions']) {
        // Add an extra query to find out if this patient is belonging to this submitter.
        define('IS_CURATOR', (bool) mysql_num_rows(mysql_query('SELECT p.submitterid FROM ' . TABLE_PATIENTS . ' AS p WHERE p.patientid = "' . $_GET['patientid'] . '" AND p.submitterid = "' . $_SUBS['submitterid'] . '"')));
    } else {
        // Whether or not a user can see non-public data.
        define('IS_CURATOR', lovd_isCurator($_SESSION['currdb']));
    }

    // If given, allele.
    if (isset($aRegs[4])) {
        $_GET['allele'] = $aRegs[4];
    }

    require ROOT_PATH . 'inc-lib-list.php';
    require ROOT_PATH . 'class/currdb.php';
    $_CURRDB = new CurrDB();
    $_CURRDB->hideCols('public', IS_CURATOR);
    require ROOT_PATH . 'inc-top.php';
    lovd_printGeneHeader();
    lovd_printHeader('variant_listings', 'LOVD - Variant listings for ' . $_SESSION['currdb']);

    if (!empty($_GET['variantid'])) {
        // Fetch patient data, patient must be associated with mentioned variantid.
        $zData = @mysql_fetch_assoc(mysql_query('SELECT p.*, p2v.status, p2v.variantid, CONCAT(s.firstname, " ", s.lastname) AS submitterid_, s.reference AS subs_reference FROM ' . TABLE_PATIENTS . ' AS p LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (p.patientid = p2v.patientid) LEFT OUTER JOIN ' . TABLE_SUBS . ' AS s ON (p.submitterid = s.submitterid) WHERE p2v.symbol = "' . $_SESSION['currdb'] . '" AND p2v.variantid = "' . $_GET['variantid'] . '" AND p.patientid = "' . $_GET['patientid'] . '"' . (IS_CURATOR? '' : ' AND p2v.status >= "' . STATUS_MARKED . '"')));
    } else {
        // 2007-08-09; 2.0-beta-07; View patient information without considering any variants is now possible.
        $zData = @mysql_fetch_assoc(mysql_query('SELECT p.*, CONCAT(s.firstname, " ", s.lastname) AS submitterid_, s.reference AS subs_reference FROM ' . TABLE_PATIENTS . ' AS p LEFT OUTER JOIN ' . TABLE_SUBS . ' AS s USING (submitterid) WHERE p.patientid = "' . $_GET['patientid'] . '"'));
    }

    if (!$zData) {
        // Wrong ID, apparently.
        lovd_showInfoTable('No such ID!', 'stop');
        lovd_printGeneFooter();
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Array which will make up the table (header and data).
    $aTable = $_CURRDB->buildTable('detail');

    // Submitter column.
    if ($zData['submitterid_'] || IS_CURATOR) {
        $aTable = array_merge(
                $aTable,
                 array(
                        'submitterid_' => 'Submitter',
                      ));
    }

    // Additional columns for authorized users.
    if (IS_CURATOR) {
        $aTable = array_merge(
                $aTable,
                 array(
                        'created_by' => 'Created by',
                        'created_date' => 'Date created',
                        'edited_by' => 'Edited by',
                        'edited_date' => 'Date edited',
                      ));

        // Remove unnecessary columns.
        if ($zData['edited_by'] == NULL) {
            // Never been edited.
            unset($aTable['edited_by'], $aTable['edited_date']);
        }
    }

    // Table.
    print('      <TABLE border="0" cellpadding="0" cellspacing="1" width="600" class="gene">');

    // Table header.
    print("\n" .
          '        <TR>' . "\n" .
          '          <TH colspan="2" class="S15">Patient data (#' . $zData['patientid'] . ')</TH>');

    // Parse and build Custom Links.
    lovd_buildLinks($zData);

    // Transform select lists' values.
    $_CURRDB->transformSelectValues($zData);

    // Submitter reference...
    if ($zData['subs_reference'] && $_CURRDB->colExists('Patient/Reference')) {
        // 2008-03-28; 2.0-05; Show full submitter information directly from this link.
        $zData['Patient/Reference'] .= (!empty($zData['Patient/Reference'])? ', ' : '') . '<A href="#" onclick="lovd_openWindow(\'' . ROOT_PATH . 'submitters.php?action=view&amp;view=' . $zData['submitterid'] . lovd_showSID(true, true) . '\', \'SubmitterView\', 400, 175, event.screenX - 50, event.screenY - 50); return false;">' . $zData['subs_reference'] . '</A>';
    }

    // 2007-08-17; 2.0-beta-07; Add link to assign submitter to this patient.
    // 2008-10-02; 2.0-13; Remove this link for submitters; they have no use for it.
    if (HAS_AUTH && IS_CURATOR) {
        $zData['submitterid_'] .= ' (<A href="#" onclick="lovd_openWindow(\'' . ROOT_PATH . 'submit_patients.php?action=assign_submitter&amp;patientid=' . $zData['patientid'] . lovd_showSID(true) . '\', \'AssignSubmitter\', 700, 150); return false;">' . (!(int) $zData['submitterid']? 'Assign' : 'Change') . '</A>)';
    }

    // Additional columns for authorized users.
    if (IS_CURATOR) {
        // Not very efficient, but I'm thinking mostly this page is viewed by
        // non-curators, so incorporating these into the main query is not very
        // efficient, either.
        if ($zData['created_by']) {
            list($sCreatedBy) = mysql_fetch_row(mysql_query('SELECT name FROM ' . TABLE_USERS . ' WHERE userid = "' . $zData['created_by'] . '"'));
            $zData['created_by'] = $sCreatedBy;
        } else {
            $zData['created_by'] = 'Submitter';
        }
        
        if (isset($aTable['edited_by'])) {
            if ($zData['edited_by']) {
                list($sEditedBy) = mysql_fetch_row(mysql_query('SELECT name FROM ' . TABLE_USERS . ' WHERE userid = "' . $zData['edited_by'] . '"'));
                $zData['edited_by'] = $sEditedBy;
            } else {
                $zData['edited_by'] = 'Submitter';
            }
        }
    }

    foreach ($aTable as $sField => $sHeader) {
        if (substr($sField, 0, 8) == 'Variant/') {
            continue;
        }

        // Textarea's can be anywhere...
        $zData[$sField] = str_replace(array("\r\n", "\r", "\n"), '<BR>', $zData[$sField]);

        print("\n" .
              '        <TR>' . "\n" .
              '          <TH valign="top">' . str_replace(' ', '&nbsp;', $sHeader) . '</TH>' . "\n" .
              '          <TD>' . (!$zData[$sField]? '-' : $zData[$sField]) . '</TD></TR>');
    }
    print('</TABLE>' . "\n\n");

    $sNavigation = '';
    $nSubmitterID = $zData['submitterid'];
    if (IS_CURATOR || (HAS_SUBS && $nSubmitterID == $_SUBS['submitterid'])) {
        // Curator, or owning submitter.
        $sNavigation .= '<A href="submit.php?action=submit&amp;add_pat=' . $zData['patientid'] . '">Add new variant to patient</A>';

        // 2008-04-21; 2.0-06; Submitters can now also edit patients when My Submissions is activated.
        // Check if user is allowed to edit patients.
        if (HAS_SUBS) {
            $bEditable = $_CONF['my_submissions'];
        } elseif ($_AUTH['level'] >= LEVEL_MANAGER) {
            $bEditable = true;
        } elseif (HAS_AUTH) {
            // Curators are not allowed to edit/delete patients also belonging to a gene they do not control.
            $bEditable = !mysql_num_rows(mysql_query('SELECT symbol FROM ' . TABLE_PAT2VAR . ' WHERE patientid = "' . $_GET['patientid'] . '" AND symbol NOT IN ("' . implode('", "', $_AUTH['curates']) . '") GROUP BY symbol'));
        }

        if ($bEditable) {
            // Authorized user (admin, manager or curator with rights on this gene) is logged in. Provide tools.
            $sNavigation .= ($sNavigation? ' | ' : '') . '<A href="submit_patients.php?action=edit&amp;edit=' . $zData['patientid'] . '">Edit patient</A>';
            if (HAS_AUTH) {
                // Just for the allowed curators and up, not for submitters.
                $sNavigation .= ' | <A href="submit_patients.php?action=drop&amp;drop=' . $zData['patientid'] . '">Delete complete submission</A>';
            }
        } else {
            $sNavigation .= ($sNavigation? ' | ' : '') . '<B style="color : #CCCCCC;">Edit patient</B>';
            if (HAS_AUTH) {
                // Just for the allowed curators and up, not for submitters.
                $sNavigation .= ' | <B style="color : #CCCCCC;">Delete complete submission</B>';
            }
        }
    }

    if ($sNavigation) {
        print('      <IMG src="gfx/trans.png" alt="" width="1" height="5"><BR>' . "\n");
        lovd_viewNavigation($sNavigation);
    }

    print('      <BR>' . "\n\n");

    // 2008-05-30; 2.0-07; Add agree to submitter's changes option.
    // 2009-04-06; 2.0-17; Added HAS_AUTH prerequisite.
    if (IS_CURATOR && HAS_AUTH && $zData['edited_by'] == 'Submitter') {
        lovd_showInfoTable('This patient entry has last been edited by a submitter. If you agree to the changes, please click here to clear this message.', 'question', 600, 'submit_patients.php?action=edit&amp;edit=' . $zData['patientid'] . '&amp;agree=true');
    }





    if (!empty($_GET['variantid'])) {
        // Fetch variant data, variant must be associated with mentioned patientid and, if given, the allele must match.
        $zData = @mysql_fetch_assoc(mysql_query('SELECT v.*, p2v.* FROM ' . TABLE_CURRDB_VARS . ' AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (v.variantid = p2v.variantid) WHERE p2v.symbol = "' . $_SESSION['currdb'] . '" AND v.variantid = "' . $_GET['variantid'] . '" AND p2v.patientid = "' . $_GET['patientid'] . '"' . (empty($_GET['allele'])? '' : ' AND p2v.allele = "' . $_GET['allele'] . '"') . (IS_CURATOR? '' : ' AND p2v.status >= "' . STATUS_MARKED . '"')));
        if (!$zData) {
            // Wrong ID, apparently.
            lovd_showInfoTable('No such ID!', 'stop');
            lovd_printGeneFooter();
            require ROOT_PATH . 'inc-bot.php';
            exit;
        }

        // Array which will make up the table (header and data).
        $aTable = $_CURRDB->buildTable('detail');

        // Additional columns for authorized users.
        if (IS_CURATOR) {
            $aTable = array_merge(
                    $aTable,
                     array(
                            'status_' => 'Status',
                            'created_by' => 'Created by',
                            'created_date' => 'Date created',
                            'edited_by' => 'Edited by',
                            'edited_date' => 'Date edited',
                          ));

            // Remove unnecessary columns.
            if ($zData['edited_by'] == NULL) {
                // Never been edited.
                unset($aTable['edited_by'], $aTable['edited_date']);
            }
        }

        // Additional columns.
        $aTable = array_merge(
                 array(
                        'allele_' => 'Allele',
                        'pathogenic_reported' => 'Reported pathogenicity',
                        'pathogenic_concluded' => 'Concluded pathogenicity',
                      ),
                $aTable);

        // Table.
        print('      <TABLE border="0" cellpadding="0" cellspacing="1" width="600" class="gene">');

        // Table header.
        print("\n" .
              '        <TR>' . "\n" .
              '          <TH colspan="2" class="S15">Variant data</TH>');

        // Parse and build Custom Links.
        lovd_buildLinks($zData);

        // Transform select lists' values.
        $_CURRDB->transformSelectValues($zData);

        // Additional columns for authorized users.
        if (IS_CURATOR) {
            $zData['status_']  = $_SETT['var_status'][$zData['status']];

            // Not very efficient, but I'm thinking mostly this page is viewed by
            // non-curators, so incorporating these into the main query is not very
            // efficient, either.
            if ($zData['created_by']) {
                list($sCreatedBy) = mysql_fetch_row(mysql_query('SELECT name FROM ' . TABLE_USERS . ' WHERE userid = "' . $zData['created_by'] . '"'));
                $zData['created_by'] = $sCreatedBy;
            } else {
                $zData['created_by'] = 'Submitter';
            }

            // 2008-12-04; 2.0-15; Added this if statement to prevent false positive "Variant entry last edited by a submitter" messages.
            if (isset($aTable['edited_by'])) {
                if ($zData['edited_by']) {
                    list($sEditedBy) = mysql_fetch_row(mysql_query('SELECT name FROM ' . TABLE_USERS . ' WHERE userid = "' . $zData['edited_by'] . '"'));
                    $zData['edited_by'] = $sEditedBy;
                } else {
                    $zData['edited_by'] = 'Submitter';
                }
            }
        }

        foreach ($aTable as $sField => $sHeader) {
            if (substr($sField, 0, 8) == 'Patient/') {
                continue;
            }

            $zData['allele_'] = $_SETT['var_allele'][$zData['allele']];
            $zData['pathogenic_reported'] = $_SETT['var_pathogenic'][$zData['pathogenic']{0}];
            $zData['pathogenic_concluded'] = $_SETT['var_pathogenic'][$zData['pathogenic']{1}];

            // Textarea's can be anywhere...
            $zData[$sField] = str_replace(array("\r\n", "\r", "\n"), '<BR>', $zData[$sField]);

            print("\n" .
                  '        <TR>' . "\n" .
                  '          <TH valign="top">' . str_replace(' ', '&nbsp;', $sHeader) . '</TH>' . "\n" .
                  '          <TD>' . (!$zData[$sField]? '-' : $zData[$sField]) . '</TD></TR>');
        }
        print('</TABLE>' . "\n\n");

        $sNavigation = '';
        if (IS_CURATOR || (HAS_SUBS && $nSubmitterID == $_SUBS['submitterid'])) {
            // Authorized user (admin, manager or curator with rights on this gene) is logged in. Provide tools.
            if (HAS_AUTH) {
                if ($zData['status'] < 9) {
                    $sNavigation = '<A href="submit_variants.php?select_db=' . $_SESSION['currdb'] . '&amp;action=edit&amp;edit=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . '&amp;curate=true">Curate variant</A>';
                } else {
                    $sNavigation = '<A style="color : #999999;">Curate variant</A>';
                }
                $sNavigation .= ($sNavigation? ' | ' : '') . '<A href="submit_variants.php?select_db=' . $_SESSION['currdb'] . '&amp;action=edit&amp;edit=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . '">Edit variant</A>';
                $sNavigation .= ' | <A href="submit_variants.php?select_db=' . $_SESSION['currdb'] . '&amp;action=drop&amp;drop=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . '">Delete variant from submission</A>';
            } elseif ($_CONF['my_submissions']) {
                // 2008-04-22; 2.0-06; Submitters can now also edit variants when My Submissions is activated.
                $sNavigation .= ($sNavigation? ' | ' : '') . '<A href="submit_variants.php?select_db=' . $_SESSION['currdb'] . '&amp;action=edit&amp;edit=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . '">Edit variant</A>';
            } else {
                $sNavigation .= ($sNavigation? ' | ' : '') . '<B style="color : #CCCCCC;">Edit variant</B>';
            }
        }

        if ($sNavigation) {
            print('      <IMG src="gfx/trans.png" alt="" width="1" height="5"><BR>' . "\n");
            lovd_viewNavigation($sNavigation);
        }

        print('      <BR>' . "\n\n");

        // 2008-10-16; 2.0-13; Add agree to submitter's changes option.
        // 2009-04-06; 2.0-17; Added HAS_AUTH prerequisite.
        if (IS_CURATOR && HAS_AUTH && $zData['edited_by'] == 'Submitter') {
            lovd_showInfoTable('This variant entry has last been edited by a submitter. If you agree to the changes, please click here to clear this message.', 'question', 600, 'submit_variants.php?select_db=' . $_SESSION['currdb'] . '&amp;action=edit&amp;edit=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . '&amp;agree=true');
        }
    }





    // On a per-gene basis, we'll list the different mutations found.
    // The tables don't have to be union compatible, so UNION is just not an option.
    $aCURRDBs = array($_SESSION['currdb'] => & $_CURRDB);

    // Get list of genes.
    $qGenes = mysql_query('SELECT DISTINCT symbol FROM ' . TABLE_PAT2VAR . ' WHERE patientid = "' . $_GET['patientid'] . '"' . (IS_CURATOR? '' : ' AND status >= ' . STATUS_MARKED) . ' ORDER BY symbol');
    while (list($sSymbol) = mysql_fetch_row($qGenes)) {
        // Per gene... list variants.

        // We need to have the CURRDB object.
        if (!isset($aCURRDBs[$sSymbol])) {
            $aCURRDBs[$sSymbol] = new CurrDB(true, $sSymbol);
            $aCURRDBs[$sSymbol]->hideCols('public', lovd_isCurator($sSymbol));
        }

        // Guess the column used to describe the mutation.
        $sMutationCol = $_CURRDB->getMutationCol();

        // Standard query, will be extended later on.
        $sQ = 'SELECT p2v.symbol, p2v.patientid, p2v.pathogenic, p2v.allele, v.*, p2v.status FROM ' . TABLEPREFIX . '_' . $sSymbol . '_variants AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (v.variantid = p2v.variantid) WHERE p2v.patientid = "' . $_GET['patientid'] . '" AND p2v.symbol = "' . $sSymbol . '"' . (IS_CURATOR? '' : ' AND p2v.status >= ' . STATUS_MARKED);

        // SORT: Current settings.
        if (isset($_GET['order']) && $_GET['order']) {
            $aOrder = explode(',', $_GET['order']);
        } else {
            $aOrder = array('', '');
        }

        // SORT: Column data.
        $aOrderList = array_merge(
                 array('sort' => array('v.sort', 'ASC')),
                 $aCURRDBs[$sSymbol]->buildOrderList());
        if (IS_CURATOR) {
            // Add status.
            $aOrderList['status'] = array('p2v.status', 'ASC');
        }
        if (!array_key_exists($aOrder[0], $aOrderList)) {
            // 2007-10-19; 2.0-01; Changed default sorting column from Exon to Variant/DNA.
            $aOrder[0] = $sMutationCol;
        }
        if ($aOrder[1] != 'ASC' && $aOrder[1] != 'DESC') {
            $aOrder[1] = $aOrderList[$aOrder[0]][1];
        }

        // 2007-10-19; 2.0-01; Fixed bug #18 - Variants do not sort correctly when selecting DNA column to sort on.
        // SORT: Additional sort columns (faking a perfect sort).
        $sOrderPre = '';
        $sOrderPost = '';
        if (in_array($aOrder[0], array('Variant/DNA', 'Variant/Exon'))) {
            // 1) In case of the mutation column, sort FIRST on Exon, and sort.
            if ($aCURRDBs[$sSymbol]->colExists('Variant/Exon')) {
                $sOrderPre .= 'v.`Variant/Exon` ' . $aOrder[1] . ', ';
            }
            $sOrderPre .= 'v.sort ' . $aOrder[1] . ', ';
        } else {
            // 2) In case of anything else, sort on Exon, and sort AFTER.
            if ($aCURRDBs[$sSymbol]->colExists('Variant/Exon')) {
                $sOrderPost .= ', v.`Variant/Exon` ' . $aOrder[1];
            }
            $sOrderPost .= ', v.sort ' . $aOrder[1];
        }

        $sQ .= ' ORDER BY ' . $sOrderPre . $aOrderList[$aOrder[0]][0] . ' ' . $aOrder[1] . $sOrderPost;



// FIXME; move up? document.forms[0], right?
        // Show form; required for sorting and searching.
        print('      <FORM action="' . $_SERVER['PHP_SELF'] . '" method="get" style="margin : 0px;">' . "\n" .
              '        <INPUT type="hidden" name="select_db" value="' . $_SESSION['currdb'] . '">' . "\n" .
              '        <INPUT type="hidden" name="action" value="' . $_GET['action'] . '">' . "\n" .
              '        <INPUT type="hidden" name="view" value="' . $_GET['view'] . '">' . "\n" .
              '        <INPUT type="hidden" name="order" value="' . implode(',', $aOrder) . '">');

        $q = mysql_query($sQ);
        if (!$q) {
            lovd_dbFout('Variants' . ucfirst($_GET['action']), $sQ, mysql_error());
        }

        $n = mysql_num_rows($q);
        print('      <SPAN class="S13"><B>' . $n . ' entr' . ($n == 1? 'y' : 'ies') . ' in ' . $sSymbol . '</B></SPAN><BR>' . "\n");

        // Array which will make up the table (header and data).
        $aTable = $aCURRDBs[$sSymbol]->buildTable('list');

        // Guess the column used to describe the mutation.
        $sMutationCol = $aCURRDBs[$sSymbol]->getMutationCol();

        // Unset patient columns...
        foreach ($aTable as $sCol => $val) {
            if (substr($sCol, 0, 8) == 'Patient/') {
                unset($aTable[$sCol]);
            }
        }

        // Additional columns for authorized users.
        if (IS_CURATOR) {
            $aTable['status'] = array('Status', 75);
        }

        // Additional columns.
        $aTable = array_merge(
                 array(
                        'pathogenic_' => array('Path.', 40),
                        'allele_' => array('Allele', 130),
                      ),
                $aTable);

        // Total width.
        $nTotalWidth = 2;
        foreach ($aTable as $aCol) {
            $nTotalWidth += $aCol[1] + 8;
        }



        // Stretch table up, to respect column widths.
        print('      <IMG src="' . ROOT_PATH . 'gfx/trans.png" alt="" width="' . $nTotalWidth . '" height="1"><BR>' . "\n\n");

        // Table.
        print('      <TABLE border="0" cellpadding="0" cellspacing="1" class="data">' . "\n" .
              '        <TR>');

        foreach ($aTable as $sField => $aCol) {
            print("\n" . '          <TH' . (!empty($aCol[2])? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . (array_key_exists($sField, $aOrderList)? ' class="order' . ($aOrder[0] == $sField? 'ed' : '') . '" onclick="document.forms[0].order.value=\'' . $sField . ',' . ($aOrder[0] == $sField? ($aOrder[1] == 'ASC'? 'DESC' : 'ASC') : $aOrderList[$sField][1]) . '\';document.forms[0].submit();"' : '') . '>' .
                  (array_key_exists($sField, $aOrderList)? "\n" .
                                                               '            <TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="S11">' . "\n" .
                                                               '              <TR>' . "\n" .
                                                               '                <TH>' . str_replace(' ', '&nbsp;', $aCol[0]) . '</TH>' . "\n" .
                                                               '                <TD align="right"><IMG src="gfx/order_arrow_desc' . ($aOrder[0] == $sField && $aOrder[1] == 'DESC'? '_sel' : '') . '.png" alt="Descending" title="Descending" width="13" height="6"><BR><IMG src="gfx/order_arrow_asc' . ($aOrder[0] == $sField && $aOrder[1] == 'ASC'? '_sel' : '') . '.png" alt="Ascending" title="Ascending" width="13" height="6"></TD></TR></TABLE>' : $aCol[0]) . '</TH>');
        }
        print('</TR>');

        while ($zData = mysql_fetch_assoc($q)) {
            print("\n" .
                  '        <TR valign="top"' . (IS_CURATOR && $zData['status'] < STATUS_OK? ' class="' . ($zData['status'] < STATUS_MARKED? 'del' : 'marked') . '"' : '') . ' style="cursor : pointer; cursor : hand;' . (!empty($_GET['variantid']) && $zData['variantid'] == $_GET['variantid'] && $zData['symbol'] == $_SESSION['currdb'] && (!isset($_GET['allele']) || $zData['allele'] == $_GET['allele'])? ' font-weight : bold;' : '') . '" onmouseover="this.className = \'' . (IS_CURATOR && $zData['status'] < STATUS_OK? ($zData['status'] < STATUS_MARKED? 'del_' : 'marked_') : '') . 'hover\';" onmouseout="this.className = \'' . (IS_CURATOR && $zData['status'] < STATUS_OK? ($zData['status'] < STATUS_MARKED? 'del' : 'marked') : '') . '\';" onclick="window.location.href = \'' . $_SERVER['PHP_SELF'] . '?select_db=' . $zData['symbol'] . '&amp;action=view&amp;view=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . lovd_showSID(true, true) . '\';">');

            $zData['pathogenic_'] = $_SETT['var_pathogenic_short'][$zData['pathogenic']];
            $zData['allele_']     = $_SETT['var_allele'][$zData['allele']];
            // Create normal anchor link as well.
            $sLink = '<A href="' . $_SERVER['PHP_SELF'] . '?select_db=' . $zData['symbol'] . '&amp;action=view&amp;view=' . $zData['patientid'] . '%2C' . $zData['variantid'] . '%2C' . $zData['allele'] . '" style="color : #' . ($zData['status'] < STATUS_MARKED? 'AAAAAA' : '000000') . '; text-decoration : none;">';
            if ($sMutationCol) {
                $zData[$sMutationCol] = $sLink . $zData[$sMutationCol] . '</A>';
            }

            // Parse and build Custom Links.
            lovd_buildLinks($zData);

            // 2008-10-10; 2.0-13; Oops, forgot to transform the selection lists's values here.
            // Transform select lists' values.
            $aCURRDBs[$sSymbol]->transformSelectValues($zData);

            // Additional columns for authorized users.
            if (IS_CURATOR) {
                $zData['status'] = $_SETT['var_status'][$zData['status']];
            }

            // FIXME;
            // Shorten strings for TEXT that surely doesn't contain HTML tags... HOW?

            foreach ($aTable as $sField => $aCol) {
                print("\n" . '          <TD' . (!empty($aCol[2])? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . ($aOrder[0] == $sField? ' class="ordered"' : '') . '>' . (!$zData[$sField]? '-' : $zData[$sField]) . '</TD>');
            }
            print('</TR>');
        }
        print('</TABLE>' . "\n");
        print('</FORM>' . "\n\n");
        print('      <BR>' . "\n\n");
    }

    lovd_printGeneFooter();
    require ROOT_PATH . 'inc-bot.php';
    exit;





} else {
    // Default action:
    header('Location: ' . PROTOCOL . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?action=view_unique' . lovd_showSID(true));
    exit;
}
?>