<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2008-09-18
 * Modified    : 2009-05-04
 * For LOVD    : 2.0-18
 *
 * Access      : Curators and up.
 * Purpose     : Provide very short information on the LOVD scripts that are
 *               available.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// Require manager clearance.
lovd_requireAUTH(LEVEL_CURATOR);





if (true) {
    // View all scripts.

    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('config_scripts', 'LOVD Configuration - LOVD scripts');

    // Table.
    print('      <TABLE border="0" cellpadding="0" cellspacing="1" width="950" class="data">' . "\n" .
          '        <TR>' . "\n" .
          '          <TH width="200">Name</TH>' . "\n" .
          '          <TH width="80">Version</TH>' . "\n" .
          '          <TH>Description</TH>' . "\n" .
          '          <TH width="100">Updated</TH></TR>' . "\n" .
          '        <TR valign="top" style="cursor : pointer; cursor : hand;" onmouseover="this.className = \'hover\';" onmouseout="this.className = \'\';" onclick="lovd_openWindow(\'' . ROOT_PATH . 'scripts/uploadGenBank.php' . lovd_showSID() . '\', \'ScriptsUploadGenBank\', 800, 300);">' . "\n" .
          '          <TD width="200"><A href="#" onclick="lovd_openWindow(\'' . ROOT_PATH . 'scripts/uploadGenBank.php' . lovd_showSID() . '\', \'ScriptsUploadGenBank\', 800, 300); return false;" class="data">GenBank File Uploader</A></TD>' . "\n" .
          '          <TD width="80">1.0</TD>' . "\n" .
          '          <TD>The GenBank uploader allows a curator to upload a GenBank file and associate it with a gene database. The GenBank file can be used for the Mutalyzer module or the Reference Sequence parser script.</TD>' . "\n" .
          '          <TD width="100">2009-04-03</TD></TR>' . "\n" .
          '        <TR valign="top" style="cursor : pointer; cursor : hand;" onmouseover="this.className = \'hover\';" onmouseout="this.className = \'\';" onclick="lovd_openWindow(\'' . ROOT_PATH . 'scripts/parseRefSeq.php' . lovd_showSID() . '\', \'ScriptsParseRefSeq\', 800, 500);">' . "\n" .
          '          <TD width="200"><A href="#" onclick="lovd_openWindow(\'' . ROOT_PATH . 'scripts/parseRefSeq.php' . lovd_showSID() . '\', \'ScriptsParseRefSeq\', 800, 500); return false;" class="data">Reference Sequence Parser</A></TD>' . "\n" .
          '          <TD width="80">2.6</TD>' . "\n" .
          '          <TD>The LOVD Reference sequence parser creates a nicely formatted HTML page of a coding DNA reference sequence, including exon/intron boundaries and separate files for upstream, intronic and downstream sequences. It accepts different input formats.</TD>' . "\n" .
          '          <TD width="100">2009-04-24</TD></TR></TABLE>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} else {
    // Default action:
    header('Location: ' . PROTOCOL . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?action=view_all' . lovd_showSID(true));
    exit;
}
?>