/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2007-10-11
 * Modified    : 2007-10-11
 * For LOVD    : 2.0-beta-10
 *
 * Access      : Curators and up.
 * Purpose     : Provide JavaScript for sorting custom columns.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

butHome_B     = new Image();
butHome_B.src = './gfx/order_button_home.png';
butHome_H     = new Image();
butHome_H.src = './gfx/order_button_home_s.png';
butUp_B     = new Image();
butUp_B.src = './gfx/order_button_up.png';
butUp_H     = new Image();
butUp_H.src = './gfx/order_button_up_s.png';
butDown_B     = new Image();
butDown_B.src = './gfx/order_button_down.png';
butDown_H     = new Image();
butDown_H.src = './gfx/order_button_down_s.png';
butEnd_B     = new Image();
butEnd_B.src = './gfx/order_button_end.png';
butEnd_H     = new Image();
butEnd_H.src = './gfx/order_button_end_s.png';

// Used for button images.
function lovd_imageSwitch (image_id, image_mode) {
    document.getElementById(image_id).src = eval(image_id + '_' + image_mode + '.src');
}

function lovd_orderUp () {
    var obj_pages = document.getElementById('select_order');
    var i = obj_pages.selectedIndex;

    if (i > 0) {
        var old_val = obj_pages.options[i-1].value;
        var old_txt = obj_pages.options[i-1].text;
        var new_val = obj_pages.options[i].value;
        var new_txt = obj_pages.options[i].text;

        obj_pages.options[i-1].value = new_val;
        obj_pages.options[i-1].text = new_txt;
        obj_pages.options[i].value = old_val;
        obj_pages.options[i].text = old_txt;
        obj_pages.selectedIndex --;
    }
}

function lovd_orderDown () {
    var obj_pages = document.getElementById('select_order');
    var i = obj_pages.selectedIndex;
    var n = obj_pages.options.length - 1;

    if (i < n) {
        var old_val = obj_pages.options[i+1].value;
        var old_txt = obj_pages.options[i+1].text;
        var new_val = obj_pages.options[i].value;
        var new_txt = obj_pages.options[i].text;

        obj_pages.options[i+1].value = new_val;
        obj_pages.options[i+1].text = new_txt;
        obj_pages.options[i].value = old_val;
        obj_pages.options[i].text = old_txt;
        obj_pages.selectedIndex ++;
    }
}

function lovd_orderSubmit () {
    var obj_pages = document.getElementById('select_order');
    for (i = 0; i < obj_pages.options.length; i ++) {
        obj_pages.options[i].selected = true;
    }
}

function lovd_orderHome () {
    var obj_pages = document.getElementById('select_order');
    var i = obj_pages.selectedIndex;

    if (i > 0) {
        for (;i>0;i--) {
            var old_val = obj_pages.options[i-1].value;
            var old_txt = obj_pages.options[i-1].text;
            var new_val = obj_pages.options[i].value;
            var new_txt = obj_pages.options[i].text;

            obj_pages.options[i-1].value = new_val;
            obj_pages.options[i-1].text = new_txt;
            obj_pages.options[i].value = old_val;
            obj_pages.options[i].text = old_txt;
            obj_pages.selectedIndex = i-1;
        }
    }
}

function lovd_orderEnd () {
    var obj_pages = document.getElementById('select_order');
    var i = obj_pages.selectedIndex;
    var n = obj_pages.options.length - 1;

    if (i < n) {
        for (;i<n;i++) {
            var old_val = obj_pages.options[i+1].value;
            var old_txt = obj_pages.options[i+1].text;
            var new_val = obj_pages.options[i].value;
            var new_txt = obj_pages.options[i].text;

            obj_pages.options[i+1].value = new_val;
            obj_pages.options[i+1].text = new_txt;
            obj_pages.options[i].value = old_val;
            obj_pages.options[i].text = old_txt;
            obj_pages.selectedIndex = i+1;
        }
    }
}