<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2009-09-25
 * Modified    : 2009-09-28
 * For LOVD    : 2.0-22
 *
 * Access      : Public
 * Purpose     : RESTful API/Web Service for LOVD.
 *               Supported (those with asterisks are not yet implemented):
 *               /api/rest.php/variants/{{ GENE }}?search_position=c.1234
 *               /api/rest.php/variants/{{ GENE }}?search_Variant%2FDNA=c.1234C>G
 *               /api/rest.php/variants/{{ GENE }}?search_Variant%2FDBID=DMD_01234
 *               /api/rest.php/variants/{{ GENE }}/{{ ID }}
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', '../');
require ROOT_PATH . 'inc-init.php';

// Will currently only allow GET.
if (!in_array($_SERVER['REQUEST_METHOD'], array('GET'))) {
    header('HTTP/1.1 501 Not Implemented');
}

// Parse URL to see what we need to do.
$aARGS = array(
                'sDataType',
                'sSymbol',
                'nID',
              );
$sDataType = $sSymbol = $nID = '';

$aPATH_INFO = explode('/', $_SERVER['PATH_INFO']);
$i = 0;
foreach ($aPATH_INFO as $sPath) {
    if (!$sPath) {
        continue;
    }
    $$aARGS[$i] = $sPath;
    $i ++;
}
if ($i < 2) {
    header('HTTP/1.1 400 Bad Request');
    die('Too few parameters.');
}
// Now we've got $sDataType, $sSymbol, $nID filled in, if data is available.





// Check if gene exists.
if (!in_array($sSymbol, lovd_getGeneList())) {
    header('HTTP/1.1 404 Not Found');
    die('This gene does not exist.');
}

// I require this one, also, to get info about available columns.
require ROOT_PATH . 'class/currdb.php';
$_CURRDB = new CurrDB(true, $sSymbol);
if (!$_CURRDB->colExists('Variant/DNA') || !$_CURRDB->colExists('Variant/DBID')) {
    header('HTTP/1.1 503 Service Unavailable');
    die('This gene does not have the Variant/DNA or the Variant/DBID fields enabled, crucial for the API.');
}

if ($nID && !preg_match('/^[0-9]+$/', $nID)) {
    header('HTTP/1.1 404 Not Found');
    die(ucfirst($sDataType) . ' ID does not exist.');
}





// First build query.
$sQ = 'SELECT v.variantid, v.`Variant/DNA`, v.`Variant/DBID` FROM ' . TABLEPREFIX . '_' . $sSymbol . '_variants AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (p2v.symbol = "' . $sSymbol . '" AND v.variantid = p2v.variantid) WHERE p2v.status >= ' . STATUS_MARKED;
$bSearching = false;
if ($nID) {
    $sQ .= ' AND v.variantid = "' . $nID . '"';
} else {
    // Ok, are we searching then?
    $aSearchableFields = array('position', 'Variant/DNA', 'Variant/DBID');
    foreach ($aSearchableFields as $sField) {
        if (!empty($_GET['search_' . $sField])) {
            $bSearching = true;
            if ($sField == 'position') {
                // This does a first match; trying to find the position at the start of the DNA field. Later this match will be made more accurate!
                $sQ .= ' AND REPLACE(REPLACE(REPLACE(REPLACE(v.`Variant/DNA`, "[", ""), "(", ""), ")", ""), "?", "") LIKE "' . $_GET['search_' . $sField] . '%"';
            } elseif ($sField == 'Variant/DNA') {
                // This matches regardless of the characters (, ) and ?.
                $sQ .= ' AND REPLACE(REPLACE(REPLACE(v.`' . $sField . '`, "(", ""), ")", ""), "?", "") = "' . str_replace(array('(', ')', '?'), ' ', $_GET['search_' . $sField]) . '"';
            } elseif ($sField == 'Variant/DBID') {
                $sQ .= ' AND v.`' . $sField . '` LIKE "' . $_GET['search_' . $sField] . '%"';
            } else {
                $sQ .= ' AND v.`' . $sField . '` = "' . $_GET['search_' . $sField] . '"';
            }
        }
    }
}
$sQ .= ' GROUP BY variantid ORDER BY v.sort, v.`Variant/DNA`';
$q = mysql_query($sQ);
$n = mysql_num_rows($q);

if ($n) {
    header('HTTP/1.1 200 OK');
} else {
    header('HTTP/1.1 404 Not Found');
}

// Start feed class.
require ROOT_PATH . 'class/feeds.php';
$sLink  = ($_CONF['location_url']? $_CONF['location_url'] : PROTOCOL . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['SCRIPT_NAME']) . '/' . ROOT_PATH)) . 'api/rest.php/' . $sDataType . '/' . $sSymbol . ($nID? '/' . $nID : '');
$sTitle = ($nID? 'Variant ' . $nID . ' of' : ($bSearching? ($n? 'R' : 'No r') . 'esults for your query of' : 'Listing of all public variants in')) . ' the ' . $sSymbol . ' gene database';
$_FEED  = new Feed($sTitle, $sLink, 'tag:' . $_SERVER['HTTP_HOST'] . ',' . $_STAT['date_install'] . ':' . $_STAT['signature'] . '/REST_api');

// Now we will create entries in the feed with the fetched data.
while ($zData = mysql_fetch_assoc($q)) {
    // Prepare other fields to be included.
    $sTitle                = substr($sSymbol, 0, strpos($sSymbol . '_', '_')) . ':' . $zData['Variant/DNA'];
    // FIXME; Variant/DBID moet geisoleerd worden. Daar hadden we code voor, toch?
    $sURL                  = ($_CONF['location_url']? $_CONF['location_url'] : PROTOCOL . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['SCRIPT_NAME']) . '/' . ROOT_PATH)) . 'variants.php?select_db=' . $sSymbol . '&amp;action=search_unique&amp;search_Variant%2FDBID=' . rawurlencode($zData['Variant/DBID']);
    $zData['created_date'] = '1970-01-01 00:00:00';
    $zData['edited_date']  = '1970-01-01 00:00:00';
    $sID                   = 'tag:' . $_SERVER['HTTP_HOST'] . ',' . substr($zData['created_date'], 0, 10) . ':' . $sSymbol . '/' . $zData['variantid'];
    $zData['created_by']   = 'Unknown';
    $zData['edited_by']    = 'Unknown';
    $sPosition             = lovd_variantToPosition($zData['Variant/DNA']);
    // Really not quite the best solution, but it kind of works. $n is decreased and if there are no more matches, it will give a 404 anyway. Still has a misleading Feed title, though!
    if ($bSearching && !empty($_GET['search_position']) && $_GET['search_position'] != $sPosition) {
        // This was a false positive! Partial match that should not have been reported. Byeeeeeeee...
        $n --; // Does not really matter at this point.
        continue;
    }
    $sContent              = 'symbol:' . $sSymbol . "\n" .
                             'id:' . $zData['variantid'] . "\n" .
                             'position:' . $sPosition . "\n" .
                             'Variant/DNA:' . $zData['Variant/DNA'] . "\n" .
                             'Variant/DBID:' . $zData['Variant/DBID'];
    $_FEED->addEntry($sTitle, $sURL, $sID, $zData['created_by'], $zData['created_date'], $zData['edited_by'], $zData['edited_date'], '', 'text', $sContent);
}

if (!$n) {
    // This happens if searching on position and there is a partial match. MySQL returns a false positive which has been filtered out now.
    header('HTTP/1.1 404 Not Found'); // This will replace the previous 200 OK status!
}

$_FEED->publish();
?>