<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2009-10-26
 * Modified    : 2009-11-04
 *
 * For LOVD    : 2.0-23
 *
 * Access      : Public
 * Purpose     : Provide a form for showing and hiding specific columns.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 *               Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';
require ROOT_PATH . 'class/currdb.php';
?>

<SCRIPT type="text/javascript">
  <!--
    function lovd_Submit (action) {
        var obj_cols = document.getElementById('manage_column');
        var columns = "";
        for (i = 0; i < obj_cols.options.length; i ++) {
            if (obj_cols.options[i].selected) {
                if (columns == "") {
                    columns = obj_cols.options[i].value;
                } else {
                    columns += "," + obj_cols.options[i].value;
                }                
            }
        }
        if (action == 'hide') {
            opener.document.forms[0].hide_col.value = columns;
        } else {
            opener.document.forms[0].show_col.value = columns;
        }

        opener.document.forms[0].submit();
        setTimeout("self.close()", 1000);
    }
  // -->
</SCRIPT>

<?php
// Whether or not a user can see non-public data.
define('IS_CURATOR', lovd_isCurator($_SESSION['currdb']));
$_CURRDB = new CurrDB();
$_CURRDB->hideCols('public', IS_CURATOR);
$_CURRDB->hideColsByTable((substr($_GET['action'], -6) == 'unique'? 'Variant' : ''));

// Which columns to hide or show
if (isset($_COOKIE[$_SETT['cookie_id'] . '_hidden_cols'])) {
    $aHiddenColumns = explode(',', $_COOKIE[$_SETT['cookie_id'] . '_hidden_cols']);
} else {
    $aHiddenColumns = array();
}

// Guess the column used to describe the mutation.
$sMutationCol = $_CURRDB->getMutationCol();

// Array which will make up the selection list.
if (substr($_GET['action'], -3) == 'all') {
    $aTable = array('pathogenic_' => 'Path.');
} else {
    $aTable = array();
}
$aTable = array_merge($aTable, $_CURRDB->buildTable('detail'));

// Additional columns for authorized users.
if (substr($_GET['action'], -3) == 'all' && IS_CURATOR) {
    $aTable['submitterid'] = 'Submitterid';
    $aTable['status_'] = 'Status';
}


require ROOT_PATH . 'inc-top-clean.php';
// Table.
print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '" method="post">' . "\n" .
      '        <TABLE border="0" cellpadding="0" cellspacing="1">' . "\n" .
      '          <TR>' . "\n" .
      '            <TD valign="top" rowspan="6" width="40%" style="padding-right : 10px;">' . "\n");
print('              <B>Select column(s) you wish to ' . (isset($_GET['hide']) ? 'hide' : 'show') . '</B><BR>' . "\n" .
          '              <SELECT name="columns[]" multiple id="manage_column">' . "\n");
foreach ($aTable as $sColid => $sColHeader) {
    if ((!isset($_GET['hide']) && in_array($sColid, $aHiddenColumns) && $sColid != $sMutationCol) || (isset($_GET['hide']) && !in_array($sColid, $aHiddenColumns) && $sColid != $sMutationCol)) {
        print('            <OPTION value="' . $sColid . '">' . $sColHeader . '</OPTION>' . "\n");
    }
}
print('              </SELECT><BR>' . "\n" .
      '              <A href="#" onclick="var list = document.forms[0][\'columns[]\']; for (i=0;i<list.options.length;i++) { list.options[i].selected = true; }; return false">Select all</A>' . "\n" .
      '            </TD></TR>' . "\n\n" . 
      '          </TABLE><BR>' . "\n\n" .
      '        <INPUT TYPE="button" value="' . (isset($_GET['hide']) ? 'Hide' : 'Show') . ' column(s)" onclick="' . (isset($_GET['hide']) ? 'lovd_Submit(\'hide\')' : 'lovd_Submit(\'show\')') . '"; return false;><BR>' . "\n" .
      '        </FORM>' . "\n\n");

require ROOT_PATH . 'inc-bot-clean.php';
exit;
?>