<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-17
 * Modified    : 2010-08-02
 * For LOVD    : 2.0-28
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Setup</H3>
            <H4>Authorized users</H4>
            <H5>Assigning curators to specific genes</H5>

            All genes in LOVD should have at least one curator, to send the new submission notifications to. All curator-level users should have at least one gene to curate, otherwise they will not be able to access the configuration area.<BR>
            Please note that a curator for a gene is not necessarily a user with the curator user level. A manager, or even the database administrator, can be appointed as a gene curator so that small LOVD installations can be configured and curated by one user account.<BR>
            <BR>

            Curator-level users will not be able to switch to any gene other than the genes in their allowed list. Managers and the database administrator will have unrestricted access to all genes. If multiple users are assigned curator for a gene, all those users will receive the submission email.<BR>
            <BR>

            To assign genes to curators, edit the user you wish to assign a gene to. At the bottom of the form is a list of available genes. Select the gene(s) you want the user to be curator for in the list "Curator for". To select all genes, click the "Select all" link next to the gene list.<BR>
            <BR>

<?php lovd_showInfoTable('To select a few genes, you can use the Ctrl and Shift keys on your keyboard. Holding the Ctrl key while clicking on an entry allows you to select or deselect this entry. You can select a range of list entries by selecting the first of the range, then holding Shift and clicking the last of the range. On a Macintosh, use the Command key in stead of the the Ctrl key.', 'information'); ?>

            Besides assigning genes to curators, managers and the database administrator can also assign curators to genes, which may be a faster method depending on your specific situation. Please note that you can only assign or remove curators from a gene database if your user level is higher than that of the user you wish to assign/remove.<BR>
            From the setup area, click the "Edit genes" link. This will show a list of all genes in this installation. Then, click the gene you'd wish to assign curators to. Below the gene's detailed information, click on the link "Add/remove curators". There you can select/deselect the gene's curators. The resulting form enables you to add or remove curators.<BR>
            <BR>

            After completing this form, you are forwarded to the page where you can sort or hide curators from the list of curators on the gene's home page and on the top of the screen. You can also access this page from the "Sort/hide curator names" link next to the "Add/remove curators" link on the gene's detailed view.<BR>
            To sort the curators active for this gene, simply move your mouse over the icon on the left of the curator name, and click and drag the name up or down. To hide a curator, simply deselect the checkbox on the right of the name. Don't forget to click the "Save" button to save the new sort order!<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
