<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2009-07-10
 * Modified    : 2009-07-13
 * For LOVD    : 2.0-20
 *
 * Access      : Administrator and managers.
 * Purpose     : Provide JavaScript for opening a new window.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *               Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 * Last edited : Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';
?>
// Load function to open up new windows.
function lovd_openWindow (var_dest, var_name, var_width, var_height, varPosX, varPosY) {
    var_name = 'LOVD_<?php echo preg_replace('/[^a-z0-9_]/i', '_', $_STAT['signature']); ?>_' + var_name;
    if (!var_width) {
        var var_width = screen.width - 100;
    }
    if (!var_height) {
        var var_height = screen.height - 200;
    }
    if (!varPosX) {
        var varPosX = 50;
    }
    if (!varPosY) {
        var varPosY = 50;
    }
    window.open(var_dest, var_name, 'width=' + var_width + ',height=' + var_height + ',left=' + varPosX + ',top=' + varPosY + ',scrollbars=1');
}