<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-01
 * Modified    : 2008-11-10
 * For LOVD    : 2.0-14
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

function lovd_buildMenu ($aPages, $sPwd = '/', $nLevel = 0)
{
    // Check input.
    if (!is_array($aPages) || !count($aPages)) {
        return false;
    }

    // Loop through the pages, provide a link if necessary.
    foreach ($aPages as $nPage => $sPage) {
        // Tmp, empty entries.
        if (!$sPage) {
            continue;
        }

        // Count indentation.
        $nIndent = ($nLevel + 1) * 2;

        // Subpages?
        if (is_array($sPage)) {
            // The sub level pages.
            print('      ' . str_repeat(' ', $nIndent) . '<BLOCKQUOTE style="margin-top : 0px;">' . "\n");
            lovd_buildMenu($sPage, $sPwd . lovd_strToFilename($aPages[$nPage - 1]) . '/', $nLevel + 1);
            print('      ' . str_repeat(' ', $nIndent) . '</BLOCKQUOTE>' . "\n");
            continue;
        }

        // Print menu item.
        print('      ' . str_repeat(' ', $nIndent) . '&middot; ' . (!$nLevel? '<SPAN class="S13"><B>' : ($nLevel == 1? '<I>' : '')) . '<A href="' . $sPwd . lovd_strToFilename($sPage) . '.php">' . $sPage . '</A>' . (!$nLevel? '</B></SPAN>' : ($nLevel == 1? '</I>' : '')) . '<BR>' . "\n");
    }
}





function lovd_findPrevNext ($aPages, $sPwd = '/', $aPrev = false, $aNext = false)
{
    // Are we done?
    if (is_array($aPrev) && is_array($aNext)) {
        return array($aPrev, $aNext);
    }

    // Check input.
    if (!is_array($aPages) || !count($aPages)) {
        return false;
    }

    // Loop through the pages.
    foreach ($aPages as $nPage => $sPage) {
        // Tmp, empty entries.
        if (!$sPage) {
            continue;
        }

        // Subpages?
        if (is_array($sPage)) {
            // The sub level pages.
            list($aPrev, $aNext) = lovd_findPrevNext($sPage, $sPwd . lovd_strToFilename($aPages[$nPage - 1]) . '/', $aPrev, $aNext);
            // Check if we need to do something.
            if (is_array($aNext) && $aPrev === true) {
                // We will need to fetch the previous entry because our 'child' couldn't reach it.
                $aPrev = array($sPwd . lovd_strToFilename($aPages[$nPage - 1]) . '.php', $aPages[$nPage - 1]);
            } elseif (is_array($aPrev) && $aNext === true && isset($aPages[$nPage + 1])) {
                // We will need to fetch the next entry because our 'child' couldn't reach it.
                $aNext = array($sPwd . lovd_strToFilename($aPages[$nPage + 1]) . '.php', $aPages[$nPage + 1]);
            }
            continue;
        }



        // Check if we found the current page.
        if ($_SERVER['PHP_SELF'] == $sPwd . lovd_strToFilename($sPage) . '.php') {
            if ($nPage) {
                // Not the first entry this menu.
                if (is_array($aPages[$nPage - 1])) {
                    // Previous entry is a list.
                    if (is_array($aPages[$nPage - 1][count($aPages[$nPage - 1])-1])) {
                        // Crap, last entry is a list, too!
                        $iLast = count($aPages[$nPage - 1]) - 1;
                        $jLast = count($aPages[$nPage - 1][$iLast]) - 1;
                        $aPrev = array($sPwd . lovd_strToFilename($aPages[$nPage - 2]) . '/' . lovd_strToFilename($aPages[$nPage - 1][$iLast - 1]) . '/' . lovd_strToFilename($aPages[$nPage - 1][$iLast][$jLast]) . '.php', $aPages[$nPage - 1][$iLast][$jLast]);
                    } else {
                        $iLast = count($aPages[$nPage - 1])-1;
                        $aPrev = array($sPwd . lovd_strToFilename($aPages[$nPage - 2]) . '/' . lovd_strToFilename($aPages[$nPage - 1][$iLast]) . '.php', $aPages[$nPage - 1][$iLast]);
                    }
                } else {
                    $aPrev = array($sPwd . lovd_strToFilename($aPages[$nPage - 1]) . '.php', $aPages[$nPage - 1]);
                }
            } else {
                // We need our 'parent' to find out about the previous link.
                $aPrev = true;
            }
            if (isset($aPages[$nPage + 1])) {
                // Not the last entry.
                if (is_array($aPages[$nPage + 1])) {
                    // Next up is a higher list. Just assume that has a normal first entry.
                    $aNext = array($sPwd . lovd_strToFilename($sPage) . '/' . lovd_strToFilename($aPages[$nPage + 1][0]) . '.php', $aPages[$nPage + 1][0]);
                } else {
                    $aNext = array($sPwd . lovd_strToFilename($aPages[$nPage + 1]) . '.php', $aPages[$nPage + 1]);
                }
            } else {
                // We need our 'parent' again...
                $aNext = true;
            }
            return array($aPrev, $aNext);
        }
    }
    
    return array($aPrev, $aNext);
}
?>