<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-04-25
 * Modified    : 2011-02-07
 * For LOVD    : 2.0-30
 *
 * Access      : Public
 * Purpose     : Select gene and provide gene homepage.
 *
 * Copyright   : 2004-2011 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *               Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// If no gene selected, present the selection list.
if (!$_SESSION['currdb'] || $_GET['action'] == 'switch_db') {
    lovd_switchDB();
}





// Whether or not a user can see non-public data.
if (lovd_isCurator($_SESSION['currdb'])) {
    define('IS_CURATOR', true);
} else {
    define('IS_CURATOR', false);
}

// Provide gene homepage.
require ROOT_PATH . 'inc-top.php';
lovd_printGeneHeader();
lovd_printHeader('gene_homepage', 'LOVD ' . $_SESSION['currdb'] . ' homepage');

// 2008-04-18; 2.0-06; Take Patient/Times_reported into account.
// To check availability of the Variant/DNA and Patient/Times_reported columns, we need the CurrDB class.
require ROOT_PATH . 'class/currdb.php';
$_CURRDB = new CurrDB();
$sMutationCol = $_CURRDB->getMutationCol();

// Number of unique variants.
if (!$sMutationCol) {
    $nUniqueVariants = '??';
} else {
    if (IS_CURATOR) {
        list($nUniqueVariants) = mysql_fetch_row(mysql_query('SELECT COUNT(DISTINCT `' . $sMutationCol . '`) FROM ' . TABLE_CURRDB_VARS . ' WHERE `' . $sMutationCol . '` NOT IN ("c.=", "c.0")'));
    } else {
        list($nUniqueVariants) = mysql_fetch_row(mysql_query('SELECT COUNT(DISTINCT v.`' . $sMutationCol . '`) FROM ' . TABLE_PAT2VAR . ' AS p2v LEFT JOIN ' . TABLE_CURRDB_VARS . ' AS v USING (variantid) WHERE p2v.symbol = "' . $_SESSION['currdb'] . '" AND p2v.status >= ' . STATUS_MARKED . ' AND `' . $sMutationCol . '` NOT IN ("c.=", "c.0")'));
    }
}

if ($_CURRDB->colExists('Patient/Times_Reported')) {
    // Number of individuals with variant(s) reported in this gene.
    // Darn... This MySQL 4.1 command can get it easily... but now?
    // Backwards compatible with 4.0 and earlier.
    // 'SELECT SUM(`Patient/Times_Reported`) FROM ' . TABLE_PATIENTS . ' WHERE patientid IN (SELECT DISTINCT patientid FROM ' . TABLE_PAT2VAR . ' WHERE symbol = "SGCA")' // Requires status check, though.
    $nTotalPatients = 0;
    $qTotalPatients = mysql_query('SELECT p.`Patient/Times_Reported` FROM ' . TABLE_PATIENTS . ' AS p LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (p2v.patientid = p.patientid) WHERE p2v.symbol = "' . $_SESSION['currdb'] . '"' . (IS_CURATOR? '' : ' AND p2v.status >= ' . STATUS_MARKED) . ' GROUP BY p.patientid');
    while ($r = mysql_fetch_row($qTotalPatients)) {
        $nTotalPatients += $r[0];
    }

    // Total number of variants found in this gene.
    list($nTotalVariants) = mysql_fetch_row(mysql_query('SELECT SUM(p.`Patient/Times_Reported`) FROM ' . TABLE_PATIENTS . ' AS p LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (p2v.patientid = p.patientid) LEFT JOIN ' . TABLE_CURRDB_VARS . ' AS v USING (variantid) WHERE symbol = "' . $_SESSION['currdb'] . '"' . (IS_CURATOR? '' : ' AND status >= ' . STATUS_MARKED) . ' AND `' . $sMutationCol . '` NOT IN ("c.=", "c.0")'));
    settype($nTotalVariants, 'int');

} else {
    // Number of individuals with variant(s) reported in this gene.
    list($nTotalPatients) = mysql_fetch_row(mysql_query('SELECT COUNT(DISTINCT patientid) FROM ' . TABLE_PAT2VAR . ' WHERE symbol = "' . $_SESSION['currdb'] . '"' . (IS_CURATOR? '' : ' AND status >= ' . STATUS_MARKED)));

    // Total number of variants found in this gene.
    list($nTotalVariants) = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_PAT2VAR . ' AS p2v LEFT JOIN ' . TABLE_CURRDB_VARS . ' AS v USING (variantid) WHERE p2v.symbol = "' . $_SESSION['currdb'] . '"' . (IS_CURATOR? '' : ' AND p2v.status >= ' . STATUS_MARKED) . ' AND `' . $sMutationCol . '` NOT IN ("c.=", "c.0")'));
}

// Curator info.
$sCurators = '';
$qCurators = mysql_query('SELECT t1.name, t1.email FROM ' . TABLE_USERS . ' AS t1 LEFT JOIN ' . TABLE_CURATES . ' AS t2 USING (userid) WHERE t2.symbol = "' . $_SESSION['currdb'] . '" AND t2.show_order > 0 ORDER BY t2.show_order, t1.level DESC, t1.name');
$nCurators = mysql_num_rows($qCurators);
$i = 0;
while ($z = mysql_fetch_assoc($qCurators)) {
    $i ++;
    $sCurators .= ($sCurators? ($i == $nCurators? ' and ' : ', ') : '') . '<A href="mailto:' . $z['email'] . '">' . $z['name'] . '</A>';
}

// Just for the Gene/Reference field... (Custom link functionality).
$_SETT['currdb']['Gene/Reference'] = $_SETT['currdb']['reference'];
lovd_buildLinks($_SETT['currdb']);

// Table.
print('      <TABLE border="0" cellpadding="0" cellspacing="1" width="950" class="gene">' . "\n" .
      '        <TR>' . "\n" .
      '          <TH valign="top" colspan="2" class="S15">General information</TH></TR>');

// 2009-09-04; 2.0-21; Link to GenBank file.
$sGenBankURL = '';
switch($_SETT['currdb']['genbank']) {
    case 1:
        // Uploaded own GenBank file.
        $sGenBankURL = 'genbank/' . $_SETT['currdb']['genbank_uri'];
        break;
    case 2:
        // NCBI GenBank record / Mutalyzer UD identifier.
        if (substr($_SETT['currdb']['genbank_uri'], 0, 3) == 'UD_') {
                if ($_MODULES->isLoaded('mutalyzer')) {
                    // Mutalyzer, plus we can actually link to it.
                    $sGenBankURL = $_MODULES->getSettings('mutalyzer', 'url') . 'custom/' . $_SETT['currdb']['genbank_uri'];
                }
        } else {
            $sGenBankURL = lovd_getExternalSource('genbank', $_SETT['currdb']['genbank_uri'], true);
        }
        break;
}

// Array which will make up the data table.
$aTable =
         array(
                'Gene name' => $_SETT['currdb']['gene'],
                'Gene symbol' => '<B>' . $_SESSION['currsymb'] . '</B>',
                'Chromosome Location' => $_SETT['currdb']['chrom_location'],
                'Database location' => $_CONF['location_name'],
                'Curator' => $sCurators,
                'Database reference for citations' => $_SETT['currdb']['Gene/Reference'],
                'PubMed references' => 'View all (unique) <A href="pubmed_references.php">PubMed references</A> in the ' . $_SESSION['currdb'] . ' database',
                'Date of creation' => date('F d, Y', strtotime($_SETT['currdb']['created_date'])),
                'Last update' => date('F d, Y', strtotime($_SETT['currdb']['updated_date'])),
                'Version' => '<B>' . $_SESSION['currsymb'] . (preg_match('/[0-9]+$/', $_SESSION['currsymb'])? ' ' : '') . date('ymd', strtotime($_SETT['currdb']['updated_date'])) . '</B>',
                'Add sequence variant' => '<A href="submit.php">Submit a sequence variant</A>',
                'First&nbsp;time&nbsp;submitters' => '<A href="submitters.php?action=register">Register here</A>',
                'Reference sequence' => '<A href="' . $_SETT['currdb']['refseq_url'] . '">' . ($_SETT['currdb']['refseq'] == 'c'? 'coding DNA r' : ($_SETT['currdb']['refseq'] == 'g'? 'Genomic r' : 'R')) . 'eference sequence</A> for describing sequence variants</B>',
                'GenBank reference' => '<A href="' . $sGenBankURL . '" target="_blank">' . $_SETT['currdb']['genbank_uri'] . '</A>',
                'Exon/intron information' => '<A href="refseq/' . $_SESSION['currdb'] . '_table.html" target="_blank">Exon/intron information table</A>',
                '<I>Total&nbsp;number&nbsp;of&nbsp;unique&nbsp;DNA&nbsp;variants&nbsp;reported</I>' => '<B>' . $nUniqueVariants . '</B>',
                '<I>Total number of individuals with variant(s)</I>' => '<B>' . $nTotalPatients . '</B>',
                '<I>Total number of variants reported</I>' => '<B>' . $nTotalVariants . '</B>',
                'Subscribe to updates of this gene' => '<A href="api/feed.php?select_db=' . $_SESSION['currdb'] . '" target="_blank"><IMG src="gfx/feed_icon.png" border="0"></A>',
                'NOTE' => str_replace(array("\r\n", "\r", "\n"), '<BR>', $_SETT['currdb']['note_index']),
              );

// Unset unused fields...
if (!$_SETT['currdb']['reference']) {
    unset($aTable['Database reference for citations']);
}
// 2010-01-13; 2.0-24; Make sure also the URL is known, before printing the link.
if (!$_SETT['currdb']['refseq'] || !$_SETT['currdb']['refseq_url']) {
    unset($aTable['Reference sequence']);
}
if (!$_SETT['currdb']['genbank'] || !$sGenBankURL) {
    unset($aTable['GenBank reference']);
}
if (!is_readable('refseq/' . $_SESSION['currdb'] . '_table.html')) {
    unset($aTable['Exon/intron information']);
}
if (!$_CONF['api_feed_history']) {
    unset($aTable['Subscribe to updates of this gene']);
}
if (!$_SETT['currdb']['note_index']) {
    unset($aTable['NOTE']);
}

foreach ($aTable as $sHeader => $sField) {
    print("\n" .
          '        <TR>' . "\n" .
          '          <TH valign="top" width="275">' . $sHeader . '</TH>' . "\n" .
          '          <TD>' . (!$sField? '-' : $sField) . '</TD></TR>');
}
print('</TABLE>' . "\n\n");





// 2009-11-24; 2.0-23; Links to genome browsers, variants_statistics and Reading Frame checker in a new block.
print('      <HR>' . "\n\n" .
      '      <TABLE border="0" cellpadding="0" cellspacing="1" width="950" class="gene">' . "\n" .
      '        <TR>' . "\n" .
      '          <TH valign="top" colspan="2" class="S15">Graphical displays and utilities</TH></TR>' . "\n" .
      '        <TR>' . "\n" .
      '          <TH valign="top" width="275"><A href="variants_statistics.php">Summary tables</A></TH>' . "\n" .
      '          <TD>Summary of all sequence variants in the ' . $_SESSION['currdb'] . ' database, sorted by type of variant (with graphical displays and statistics)</TD></TR>');

if (is_readable(ROOT_PATH . 'refseq/' . $_SESSION['currdb'] . '_table.txt')) {
    print("\n" .
          '        <TR>' . "\n" .
          '          <TH valign="top" width="275"><A href="#" onclick="lovd_openWindow(\'' . ROOT_PATH . 'scripts/readingFrameChecker.php' . lovd_showSID() . '\', \'ScriptsReadingFrameChecker\', 800, 500); return false;" class="data">Reading-frame checker</A></TH>' . "\n" .
          '          <TD>The Reading-frame checker generates a prediction of the effect of whole-exon changes</TD></TR>');
}
if ($_SETT['currdb']['refseq_mrna'] && $_SETT['currdb']['refseq_build'] != '----') {
    $sChromosome = preg_replace('/^([0-9]{1,2}|[MXY])([pqtercen0-9.-]+)?$/', "$1", $_SETT['currdb']['chrom_location']);
    $nStart = min($_SETT['currdb']['g_position_mrna_start'], $_SETT['currdb']['g_position_mrna_end']) - 50;
    $nEnd   = max($_SETT['currdb']['g_position_mrna_start'], $_SETT['currdb']['g_position_mrna_end']) + 50;
    // 2010-01-20; 2.0-24; The UCSC can't handle BED files through SSL! So BED files will be delivered without SSL (UCSC & NCBI).
    // 2010-01-27; 2.0-24; Add "complement_hg19=1" to URL if gene is on - strand.
    $sURLBedFile = rawurlencode(($_CONF['location_url']? str_replace('https://', 'http://', $_CONF['location_url']) : 'http://' . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['SCRIPT_NAME']) . '/' . ROOT_PATH)) . 'api/rest.php/variants/' . $_SESSION['currdb'] . '?format=text/bed');
    $sURLUCSC = 'http://genome.ucsc.edu/cgi-bin/hgTracks?clade=mammal&amp;org=Human&amp;db=' . $_SETT['currdb']['refseq_build'] . '&amp;position=chr' . $sChromosome . ':' . $nStart . '-' . $nEnd . ($_SETT['currdb']['g_position_mrna_start'] < $_SETT['currdb']['g_position_mrna_end']? '' : '&amp;complement_hg19=1') . '&amp;hgt.customText=' . $sURLBedFile;
    // 2010-07-07; 2.0-28; Introduce the link to Ensembl. The weird addition in the end is to fake a proper name in Ensembl.
    // 2011-02-07; 2.0-30; Fix link to Ensembl if human build is not hg19!
    if ($_SETT['currdb']['refseq_build'] == 'hg18') {
        $sURLEnsembl = 'http://may2009.archive.ensembl.org/Homo_sapiens/Location/View?r=' . $sChromosome . ':' . $nStart . '-' . $nEnd . ';data_URL=' . $sURLBedFile . rawurlencode('&name=/' . $_SESSION['currdb'] . ' variants');
    } elseif ($_SETT['currdb']['refseq_build'] == 'hg19') {
        $sURLEnsembl = 'http://www.ensembl.org/Homo_sapiens/Location/View?r=' . $sChromosome . ':' . $nStart . '-' . $nEnd . ';data_URL=' . $sURLBedFile . rawurlencode('&name=/' . $_SESSION['currdb'] . ' variants');
    }
    print("\n" .
          '        <TR>' . "\n" .
          '          <TH valign="top" width="275"><A href="' . $sURLUCSC . '" target="_blank">UCSC Genome Browser</A></TH>' . "\n" .
          '          <TD>Show variants in the UCSC Genome Browser (<A href="' . $sURLUCSC . rawurlencode('&visibility=4') . '" target="_blank">compact view</A>)</TD></TR>' . "\n" .
          '        <TR>' . "\n" .
          '          <TH valign="top" width="275"><A href="' . $sURLEnsembl . '" target="_blank">Ensembl Genome Browser</A></TH>' . "\n" .
          '          <TD>Show variants in the Ensembl Genome Browser</TD></TR>' . "\n" .
          '        <TR>' . "\n" .
          '          <TH valign="top" width="275"><A href="http://www.ncbi.nlm.nih.gov/nuccore/' . $_SETT['human_builds'][$_SETT['currdb']['refseq_build']]['ncbi_sequences'][$sChromosome] . '?report=graph&amp;v=' . $nStart . ':' . $nEnd . '&amp;theme=Expanded&amp;content=7&amp;url=' . $sURLBedFile . '" target="_blank">NCBI Sequence Viewer</A></TH>' . "\n" .
          '          <TD>Show distribution histogram of variants in the NCBI Sequence Viewer</TD></TR>');
}
print('</TABLE>' . "\n\n");




if ($nTotalVariants) {
    // Curated entries (public) or all entries (curator and up).
    print('      <HR>' . "\n\n" .
          '      <TABLE border="0" cellpadding="0" cellspacing="1" width="950" class="gene">' . "\n" .
          '        <TR>' . "\n" .
          '          <TH valign="top" colspan="2" class="S15">Sequence variant tables</TH></TR>');

    // Array which will make up the data table.
    $aTable =
             array(
                    '<A href="variants.php?select_db=' . $_SESSION['currdb'] . '&amp;action=view_unique">Unique sequence variants</A>' => 'Listing of all unique sequence variants in the ' . $_SESSION['currdb'] . ' database, without patient data',
                    '<A href="variants.php?select_db=' . $_SESSION['currdb'] . '&amp;action=view_all">Complete&nbsp;sequence&nbsp;variant&nbsp;listing</A>' => 'Listing of all sequence variants in the ' . $_SESSION['currdb'] . ' database',
                    '<A href="variants.php?select_db=' . $_SESSION['currdb'] . '&amp;action=search_unique&amp;search_pathogenic_=-">Variants with no known pathogenicity</A>' => 'Listing of all ' . $_SESSION['currsymb'] . ' variants reported to have no noticeable phenotypic effect (note: excluding variants of unknown effect)',
                    '<A href="download.php?action=view_all">Download table</A>' => 'Download the full sequence variant table of the ' . $_SESSION['currdb'] . ' database in tab-delimited text format.',
                  );

    // Unset download link...
    if (!$_SETT['currdb']['allow_download']) {
        unset($aTable['<A href="download.php?action=view_all">Download table</A>']);
    }

    foreach ($aTable as $sHeader => $sField) {
        print("\n" .
              '        <TR>' . "\n" .
              '          <TH valign="top" width="275">' . $sHeader . '</TH>' . "\n" .
              '          <TD>' . (!$sField? '-' : $sField) . '</TD></TR>');
    }
    print('</TABLE>' . "\n\n");



    // Search forms.
    print('      <HR>' . "\n\n" .
          '      <TABLE border="0" cellpadding="0" cellspacing="1" width="950" class="gene">' . "\n" .
          '        <TR>' . "\n" .
          '          <TH valign="top" colspan="2" class="S15">Search the database</TH></TR>');

    // Array which will make up the data table.
    $aTable =
             array(
                    '<A href="variants_search.php?show=type">By&nbsp;type&nbsp;of&nbsp;variant</A>' => 'View all sequence variants of a certain type',
                    '<A href="variants_search.php?show=quick">Simple search</A>' => 'Query the database by selecting the most important variables (exon number, type of variant, disease phenotype)',
                    '<A href="variants_search.php?show=full">Advanced&nbsp;search</A>' => 'Query the database by selecting a combination of variables',
                    '<A href="variants_overview_origin.php">Based on patient origin</A>' => 'View all variants based on your patient origin search terms',
                  );

    // 2008-09-26; 2.0-12; Enable special search feature.
    if (HAS_AUTH || $_CONF['search_count_entries']) {
        $aTable['<A href="variants_search.php?action=count_all">Search&nbsp;through&nbsp;hidden&nbsp;entries</A>'] = 'Find the number of variant entries in the database (including hidden entries) matching your search terms.';
    }

    foreach ($aTable as $sHeader => $sField) {
        print("\n" .
              '        <TR>' . "\n" .
              '          <TH valign="top" width="275">' . $sHeader . '</TH>' . "\n" .
              '          <TD>' . (!$sField? '-' : $sField) . '</TD></TR>');
    }
    print('</TABLE>' . "\n\n");
}





// Some extra links.
if ($_SETT['currdb']['url_homepage'] || $_SETT['currdb']['url_external'] || $_SETT['currdb']['id_hgnc'] || $_SETT['currdb']['id_entrez'] || $_SETT['currdb']['id_omim_gene']
    || $_SETT['currdb']['id_omim_disease'] || $_SETT['currdb']['id_uniprot'] || $_SETT['currdb']['show_hgmd'] || $_SETT['currdb']['show_genecards'] || $_SETT['currdb']['show_genetests']) {
    print('      <HR>' . "\n\n" .
          '      <TABLE border="0" cellpadding="0" cellspacing="1" width="950" class="gene">' . "\n" .
          '        <TR>' . "\n" .
          '          <TH valign="top" colspan="2" class="S15">Links to other resources</TH></TR>');

    // Array which will make up the data table.
    $aTable = array();

    if ($_SETT['currdb']['url_homepage']) {
        $aTable['Homepage'] = '<A href="' . $_SETT['currdb']['url_homepage'] . '" target="_blank">' . $_SETT['currdb']['url_homepage'] . '</A>';
    }

    if ($_SETT['currdb']['url_external']) {
        $aLinks = explode("\r\n", $_SETT['currdb']['url_external']);

        $i = 1;
        foreach ($aLinks as $sLink) {
            if (preg_match('/^(.+) <(.+)>$/', $sLink, $aRegs)) {
                $aTable['External link' . (count($aLinks) > 1? ' #' . $i : '')] = (isset($aTable['External link'])? $aTable['External link'] . '<BR>' : '') . '<A href="' . $aRegs[2] . '" target="_blank">' . $aRegs[1] . '</A>';
            } else {
                $aTable['External link #' . $i] = (isset($aTable['External link'])? $aTable['External link'] . '<BR>' : '') . '<A href="' . $sLink . '" target="_blank">' . $sLink . '</A>';
            }
            $i++;
        }
    }

    // 2010-04-27; 2.0-26; Adding link to the HGNC, if it's available.
    if ($_SETT['currdb']['id_hgnc']) {
        $aTable['HGNC'] = '<A href="' . lovd_getExternalSource('hgnc', $_SETT['currdb']['id_hgnc'], true) . '" target="_blank">' . $_SETT['currdb']['id_hgnc'] . '</A>';
    }

    if ($_SETT['currdb']['id_entrez']) {
        $aTable['Entrez Gene'] = '<A href="' . lovd_getExternalSource('entrez', $_SETT['currdb']['id_entrez'], true) . '" target="_blank">' . $_SETT['currdb']['id_entrez'] . '</A>';
    }

    if ($_SETT['currdb']['id_omim_gene']) {
        $aTable['OMIM - Gene'] = '<A href="' . lovd_getExternalSource('omim_gene', $_SETT['currdb']['id_omim_gene'], true) . '" target="_blank">' . $_SETT['currdb']['id_omim_gene'] . '</A>';
    }

    if ($_SETT['currdb']['id_omim_disease']) {
        $aOMIM = explode("\r\n", $_SETT['currdb']['id_omim_disease']);

        $i = 1;
        foreach ($aOMIM as $sOMIM) {
            preg_match('/^([0-9]+) (.+)$/', $sOMIM, $aRegs);
            $aTable['OMIM - Disease' . (count($aOMIM) > 1? ' #' . $i : '')] = '<A href="' . lovd_getExternalSource('omim_disease', $aRegs[1], true) . '" target="_blank">' . $aRegs[2] . '</A>';
            $i++;
        }
    }

    // 2009-08-18; 2.0-21; added by Gerard, link to UniprotKB/SwissProt
    if ($_SETT['currdb']['id_uniprot']) {
        $aTable['UniProtKB (SwissProt/TrEMBL)'] = '<A href="' . lovd_getExternalSource('uniprot', $_SETT['currdb']['id_uniprot'], true) . '" target="_blank">' . $_SETT['currdb']['id_uniprot'] . '</A>';
    }

    if ($_SETT['currdb']['show_hgmd']) {
        // New format (actually the offical gene symbol).
        $aTable['HGMD'] = '<A href="' . lovd_getExternalSource('hgmd', $_SESSION['currsymb'], true) . '" target="_blank">' . $_SESSION['currsymb'] . '</A>';
    }
    
    // 2009-08-18; 2.0-21; added by Gerard, link to GeneCards
    if ($_SETT['currdb']['show_genecards']) {
        $aTable['GeneCards'] = '<A href="' . lovd_getExternalSource('genecards', $_SESSION['currsymb'], true) . '" target="_blank">' . $_SESSION['currsymb'] . '</A>';
    }

    if ($_SETT['currdb']['show_genetests']) {
        $aTable['GeneTests'] = '<A href="' . lovd_getExternalSource('genetests', $_SESSION['currsymb'], true) . '" target="_blank">' . $_SESSION['currsymb'] . '</A>';
    }

    // Print table contents.
    foreach ($aTable as $sHeader => $sField) {
        print("\n" .
              '        <TR>' . "\n" .
              '          <TH valign="top" width="275">' . $sHeader . '</TH>' . "\n" .
              '          <TD>' . (!$sField? '-' : $sField) . '</TD></TR>');
    }

    print('</TABLE>' . "\n\n");
}





if ($_SETT['currdb']['disclaimer']) {

    if ($_SETT['currdb']['disclaimer'] == 2) {
        $sMessage = $_SETT['currdb']['disclaimer_text'];
    } else {
        $sMessage = 'The contents of this LOVD database are the intellectual property of the respective curator(s). Any unauthorised use, copying, storage or distribution of this material without written permission from the curator(s) will lead to copyright infringement with possible ensuing litigation. Copyright &copy; ' . date('Y') . '. All Rights Reserved. For further details, refer to Directive 96/9/EC of the European Parliament and the Council of March 11 (1996) on the legal protection of databases.<BR><BR>We have used all reasonable efforts to ensure that the information displayed on these pages and contained in the databases is of high quality. We make no warranty, express or implied, as to its accuracy or that the information is fit for a particular purpose, and will not be held responsible for any consequences arising out of any inaccuracies or omissions. Individuals, organisations and companies which use this database do so on the understanding that no liability whatsoever either direct or indirect shall rest upon the curator(s) or any of their employees or agents for the effects of any product, process or method that may be produced or adopted by any part, notwithstanding that the formulation of such product, process or method may be based upon information here provided.';
    }

    // Table.
    print('      <HR>' . "\n\n" .
          '      <TABLE border="0" cellpadding="0" cellspacing="1" width="950" class="gene">' . "\n" .
          '        <TR>' . "\n" .
          '          <TH valign="top" class="S15">Copyright &amp; disclaimer</TH></TR>' . "\n" .
          '        <TR class="S11">' . "\n" .
          '          <TD>' . $sMessage . '</TD></TR>');

    print('</TABLE>' . "\n\n");
}





print('<BR>');
lovd_printGeneFooter();
require ROOT_PATH . 'inc-bot.php';
?>