<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2008-07-25
 * Modified    : 2008-07-25
 * For LOVD    : 2.0-09
 *
 * Access      : Public
 * Purpose     : Declare standard LOVD functions that are needed for the
 *               documentation section.
 *
 * Copyright   : 2004-2008 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

/*
function lovd_showImage ($s_url, $s_align, $s_alt = '')
{
    $a_align = array('left', 'right');

    if ($s_align && !in_array($s_align, $a_align)) {
        $s_align = 'left';
    }

    if (is_readable($s_url)) {
        $a_size = getimagesize($s_url);
    }

    print('            <TABLE border="0" cellpadding="0" cellspacing="0" width="' . $a_size[0] . '"' . (!$s_align? '' : ' align="' . $s_align . '"') . ' class="S11"' . (!$s_align? '' : ' style="padding-' . ($s_align == 'left'? 'right' : 'left') . ' : 10px; padding-bottom : 10px;"') . '>' . "\n" .
          '              <TR>' . "\n" .
          '                <TD><IMG src="' . $s_url . '" alt="' . $s_alt . '" title="' . $s_alt . '" ' . $a_size[3] . '><BR>' . "\n" .
          '                  <B>' . $s_alt . '</B></TD></TR></TABLE>' . "\n\n");
}
*/





function lovd_strToFilename ($s)
{
    // Van een naam een filename maken, een aantal stappen.
    // Kleine letters...
    $s = strtolower($s);
    // Weg met HTML tags en entities.
    $s = strip_tags($s);
    $s = str_replace('&nbsp;', ' ', $s);
    $s = unhtmlentities($s);
    // Dag spaties...
    $s = str_replace(' ', '_', $s);
    // Ampersand...
    $s = str_replace('_&_', '_n_', $s);
    // De rest gaat eruit.
    $s = preg_replace('/[^a-z_-]/i', '', $s);
    // Evt. dubbele underscores eruit, en klaar is Kees.
    $s = preg_replace('/_+/', '_', $s);

    return $s;
}





function unhtmlentities ($string)
{
    // Required by lovd_strToFilename; taken from PHP manual.
    $trans_tbl = get_html_translation_table(HTML_ENTITIES);
    $trans_tbl = array_flip($trans_tbl);
    return strtr($string, $trans_tbl);
}
?>