<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-09
 * Modified    : 2009-09-07
 * For LOVD    : 2.0-21
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Setup</H3>
            <H4>Custom columns</H4>
            <H5>Creating new columns</H5>

            Using the "Create new custom column" link from the setup area you can create a new variant or patient custom column, which will be inactive unless you explicitly add it to either a variant table or the patient table.<BR>
            <BR>

            <H6>Column name and descriptions</H6>
            <B>Category</B>: Select if this column is a patient or variant column. You can't change this value later on!<BR>
            <B>Column ID</B>: Choose a simple unique name for your column, consisting of only letters, numbers and underscores. Subcategories must be divided by a slash (/), such as "Phenotype/Disease". Do <I>NOT</I> add 'Patient/' or 'Variant/' here.<BR>
            <B>Column heading</B>: This will appear above the column on the variant listings and on the legend. In principle, this is free text, but try to keep it short, because a long name will increase the width of the column.<BR>
            <B>Description on form</B>: If you think this field may require some explanation on the submission form about what to put in there, you can add a description here.<BR>
            <B>Description on short legend</B>: Describe the meaning of the column in short. This will appear in the short legend, below the variant tables.<BR>
            <B>Description on full legend</B>: Describe the meaning of the column. You can be more elaborate here. This text will be shown on the full legend.<BR>
            <BR>

            <H6>Data settings</H6>
            There are two ways to define the data type of your custom column. The recommended way is to use the data type wizard, which will fill in the MySQL and the form type values. Only if you really know what you're doing, you can edit the MySQL data type and the form type directly.<BR>
            <BR>

            To use the data type wizard, you first need to select what type of field you want to create for your custom column:<BR>
            <B>Basic form style</B>: Select what type of field you want to create:<BR>
            <UL style="margin : 0px;">
              <LI><I>Text/numeric input field</I> for a standard input field allowing textual or numerical free text input.</LI>
              <LI><I>Integer input field</I> for a standard input field allowing only whole numbers.</LI>
              <LI><I>Decimal input field</I> for a standard input field allowing only numbers with a certain number of decimals.</LI>
              <LI><I>Large multi-row textual input field</I> for a large text field with multiple rows, allowing large amounts of text to be filled in.</LI>
              <LI><I>Drop down list (one option selected)</I> for a drop down list with a set of options of which the user must choose one value.</LI>
              <LI><I>Selection list (multiple options selected)</I> for a selection list where the user can select one or more options (like the detection technique list).</LI>
              <LI><I>Date input field</I> for a standard input field allowing for dates (year, month, day), optionally also storing time (hours, minutes, seconds).</LI>
              <LI><I>On/off checkbox</I> for a simple checkbox allowing only a yes/no answer.</LI>
            </UL>
            <BR>

            The next page shows you some additional options that depend on the type of field you've chosen:<BR>
            <B>Column name on form</B> (all field types): The name the column will have on the submission form.<BR>
            <B>Width on form</B> (all input fields and text area): The input field width on the form, in number of characters.<BR>
            <B>Maximum input length</B> (text and integer input field types): The maximum number of characters allowed the be filled in. If a user tries to enter more characters in your field, an error is issued.<BR>
            <B>Regular expression pattern</B> (text input only): For advanced users, you can enter a full regular expression pattern (PHP's Perl-compatible regular expression syntax), including the / delimiters and possible modifiers. Using this, you can force a certain format for the input.<BR>
            <B>Number of digits before the decimal point</B> (decimal field only): The maximum number of digits allowed before the decimal point. This practically limits the maximum value of the field.<BR>
            <B>Number of digits following the decimal point</B> (decimal field only): The maximum number of digits allowed at the right of the decimal point. This limits the maximum precision of values in the field.<BR>
            <B>Allow only positive values</B> (integer and decimal fields): Select this to allow only positive whole numbers to be entered.<BR>
            <B>Also store time</B> (date field only): Select this to also store time (hours, minutes, seconds) in this date field.<BR>
            <B>Height on form</B> (text area and multiple selection list): The height of your field on the submission form, in lines.<BR>
            <B>Provide "-- select --" option</B> (drop down list only): Adds a "-- select --" option to the list of options, that will be selected by default. If this option is not set, the first option of the list will be the default selected option.<BR>
            <B>Provide "select all" link</B> (multiple selection list only): Adds a "select all" link, which allows the user to select all available options in the list with one click of a button.<BR>
            <B>List of possible options</B> (both list types): Enter the options available for this field, one options per line. If you want to use abbreviations, use: Abbreviation = Long name, like &quot;DMD = Duchenne Muscular Dystrophy&quot;.<BR>
            <B>Default value</B> (all input fields except text area): A default value that will appear in the field for new submissions.<BR>
            <BR>

            When you click the "Finish" button, the data type wizard will fill in the "MySQL data type" and "Form type" fields for you.<BR>
            <BR>

            <H6>Column settings</H6>
            <B>Standard for new genes</B>: This controls whether new variant columns that you create will be added to newly created genes by default or not. All variant columns with this option set, will be added to the variant tables of newly created genes.<BR>
            <B>Mandatory field</B>: With this option selected, users can't leave your column empty.<BR>
            <B>Show contents to public</B>: With this option selected, only authorized viewers can see the contents of this column.<BR>
            <B>Show field on public forms</B>: This option controls whether or not submitters can submit a value for this column.<BR>
            <B>Include in search form</B>: This option controls whether or not this column shows on the special search overview that allows the public to find the number of entries in the database (including hidden entries) matching one or more search terms on a specified set of columns.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
