<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-10-31
 * Modified    : 2008-04-18
 * For LOVD    : 2.0-06
 *
 * Access      : Public
 * Purpose     : Provide gene-specific full legend.
 *
 * Copyright   : 2004-2008 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// If no gene selected, forward to the select list.
if (!$_SESSION['currdb']) {
    header('Location: ' . PROTOCOL . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/home.php' . lovd_showSID());
    exit;
}

// Whether or not a user can see non-public data.
if (lovd_isCurator($_SESSION['currdb'])) {
    define('IS_CURATOR', true);
} else {
    define('IS_CURATOR', false);
}





require ROOT_PATH . 'class/currdb.php';
$_CURRDB = new CurrDB();
$_CURRDB->hideCols('public', IS_CURATOR);
require ROOT_PATH . 'inc-top-clean.php';
lovd_printHeader('variant_legend', 'LOVD - Legend for ' . $_SESSION['currdb']);

print('      <HR><BR>' . "\n\n" .
      '      Sequence variations are described basically as recommended by the Ad-Hoc Nomenclature Committee of the Human Genome Variation Society (<A href="http://www.HGVS.org">HGVS</A>). For the most recent recommendations see the HGVS "<A href="http://www.hgvs.org/mutnomen/"><B>Nomenclature for the description of sequence variants</B></A>" web page. The most recent publication on the subject is by <A href="http://www3.interscience.wiley.com/cgi-bin/abstract?ID=68503056"><I>den Dunnen JT &amp; Antonarakis SE (2000), Hum.Mut. 15: 7-12</I></A>.<BR><BR>' . "\n\n");

// Full legend...
print(($_SETT['currdb']['refseq']? '      <A href="' . $_SETT['currdb']['refseq_url'] . '">' . ($_SETT['currdb']['refseq'] == 'c'? 'Coding DNA ' : ($_SETT['currdb']['refseq'] == 'g'? 'Genomic ' : '')) . 'Reference Sequence</A>' . ($_SETT['currdb']['refseq'] == 'c'? ', with the first base of the Met-codon counted as position 1' : '') . '.<BR><BR>' . "\n" : '') .
      '      NOTE: in all cases, unless indicated otherwise, all data of an entry are as reported by the author(s)/submitter.<BR><BR>' . "\n\n" .
      '      <B>Path.</B>: Variant pathogenicity, in the format Reported/Concluded; \'+\' indicating the variant is pathogenic, \'+?\' probably pathogenic, \'-\' no known pathogenicity, \'-?\' probably no pathogenicity, \'?\' effect unknown.<BR><BR>' . "\n" .
      $_CURRDB->buildLegend('full') .
      (IS_CURATOR? '      <B>Status</B>: Status of this variant entry.<BR>
      <UL style="margin-top : 0px;">
        <LI>Submitted = Newly submitted entry, only visible to curators</LI>
        <LI>Non public = Entry has been made invisible to the general public by a curator</LI>
        <LI>Marked = Entry can be seen by the public, but it is marked (to curators it appears red), for instance because some more work is needed on the entry</LI>
        <LI>Public = Entry has been published to the public</LI>
      </UL><BR>' : '') .
      "\n\n");

require ROOT_PATH . 'inc-bot-clean.php';
exit;
?>