<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2010-01-14
 * Modified    : 2011-05-26
 * For LOVD    : 3.0-alpha-01
 *
 * Copyright   : 2004-2011 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *               Ing. Ivar C. Lugtenburg <I.C.Lugtenburg@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************/

// Don't allow direct access.
if (!defined('ROOT_PATH')) {
    exit;
}

define('_INC_TOP_INCLUDED_', true);

// Load menu.
// FIXME; this needs to be a dropdown menu (like www.lgtc.nl)
$_MENU = array(
                'genes' => (!empty($_SESSION['currdb'])? $_SESSION['currdb'] . ' homepage' : 'Home'),
                 array(
                        '' => array('View all genes', 0),
                        'create' => array('Create a new gene entry', LEVEL_MANAGER),
                      ),
                'transcripts' => 'View transcripts',
                 array(
                        '' => array('View all transcripts', 0),
                        'create' => array('Create a new transcript information entry', LEVEL_CURATOR),
                      ),
                'variants' => 'View variants',
                 array(
                        '' => array('View all genomic variants', 0),
                        '/submit' => array('Create a new data submission', LEVEL_SUBMITTER),
                      ),
                'individuals' => 'View individuals',
                 array(
                        '' => array('View all individuals', 0),
                        '/submit' => array('Create a new data submission', LEVEL_SUBMITTER),
                      ),
                'diseases' => 'View diseases',
                 array(
                        '' => array('View all diseases', 0),
                        'create' => array('Create a new disease information entry', LEVEL_MANAGER), // FIXME; level_curator?
                      ),
                'screenings' => 'View screenings',
//                'submit' => 'Submit new data', // Temp disabled.
                'users' => 'LOVD users &amp; submitters',
                'setup' => 'LOVD system setup',
//                'docs' => 'LOVD documentation',
              );

// Remove certain menu entries, if the user has no access to them.
if (!$_AUTH || $_AUTH['level'] < LEVEL_MANAGER) {
    unset($_MENU['users']); // FIXME; Submitter list should be public.
    unset($_MENU['setup']);
}

if (!defined('PAGE_TITLE')) {
    $sFile = substr(lovd_getProjectFile(), 1, strrpos(lovd_getProjectFile(), '.') - 1);
    if (array_key_exists($sFile, $_MENU)) {
        define('PAGE_TITLE', $_MENU[$sFile]);
    } else {
        define('PAGE_TITLE', '');
    }
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" 
        "http://www.w3.org/TR/html4/strict.dtd">
<HTML lang="en_US">
<HEAD>
  <TITLE><?php echo (!PAGE_TITLE? '' : PAGE_TITLE . ' - ') . $_CONF['system_title']; ?></TITLE>
  <META http-equiv="Content-Type" content="text/html; charset=UTF-8"> 
  <META name="author" content="LOVD development team, LUMC, Netherlands">
  <META name="generator" content="gPHPEdit / GIMP @ GNU/Linux (Ubuntu)">
  <BASE href="<?php echo lovd_getInstallURL(); ?>">
  <LINK rel="stylesheet" type="text/css" href="styles.css">
  <LINK rel="shortcut icon" href="favicon.ico" type="image/x-icon">
<?php
lovd_includeJS('inc-js-openwindow.php', 1);
lovd_includeJS('inc-js-toggle-visibility.js', 1); // Used on forms and variant overviews for small info tables.
?>
</HEAD>

<BODY style="margin : 0px;">

<TABLE border="0" cellpadding="0" cellspacing="0" width="100%"><TR><TD>

<TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="logo">
  <TR>
<?php
if (!is_readable(ROOT_PATH . $_CONF['logo_uri'])) {
    $_CONF['logo_uri'] = 'gfx/LOVD_logo130x50.jpg';
}
$aImage = @getimagesize(ROOT_PATH . $_CONF['logo_uri']);
if (!is_array($aImage)) {
    $aImage = array('130', '50', '', 'width="130" heigth="50"');
}    
list($nWidth, $nHeight, $sType, $sSize) = $aImage;
print('    <TD valign="top" width="' . ($nWidth + 20) . '" height="' . ($_CONF['logo_uri'] == 'gfx/LOVD_logo130x50'? $nHeight : $nHeight + 20) . '">' . "\n" .
      '      <IMG src="' . $_CONF['logo_uri'] . '" alt="LOVD - Leiden Open Variation Database" ' . $sSize . '>' . "\n");
?>
    </TD>
<?php
$sCurrSymbol = $sCurrGene = '';
print('    <TD valign="top" style="padding-top : 2px;">' . "\n" .
      '      <H2 style="margin-bottom : 2px;">' . $_CONF['system_title'] . '</H2>' . "\n" .
      ($sCurrSymbol && $sCurrGene? '      <H5 id="gene_name">' . $sCurrGene . ' (' . $sCurrSymbol . ')&nbsp;<A href="#" onclick="javascript:lovd_switchGeneInline(); return false;"><IMG src="gfx/lovd_database_switch_inline.png" width="23" height="23" alt="Switch gene" title="Switch gene database" align="top"></A></H5>' . "\n" : '') .
      '    </TD>' . "\n" .
      '    <TD valign="top" align="right" style="padding-right : 5px; padding-top : 2px;">' . "\n" .
      '      LOVD v.' . $_STAT['tree'] . ' Build ' . $_STAT['build'] . ' [ <A href="status">Current LOVD status</A> ]<BR>' . "\n");
if ($_AUTH) {
    print('      <B>Welcome, ' . $_AUTH['name'] . '</B><BR>' . "\n" .
          '      <A href="users/' . $_AUTH['id'] . '"><B>Your account</B></A> | ' . ($_AUTH['level'] == LEVEL_SUBMITTER && $_CONF['allow_submitter_mods']? '<A href="variants?search_created_by=' . $_AUTH['id'] . '"><B>Your submissions</B></A> | ' : '') . '<A href="logout"><B>Log out</B></A><BR>' . "\n");
} else {
    print('      <A href="users?register"><B>Register as submitter</B></A> | <A href="login"><B>Log in</B></A><BR>' . "\n");
}

print('    </TD>' . "\n" .
      '  </TR>' . "\n");

// Add curator info to header.
if ($sCurrSymbol && $sCurrGene) {
    $sCurators = '';
    $qCurators = lovd_queryDB('SELECT u.name, u.email FROM ' . TABLE_USERS . ' AS u LEFT JOIN ' . TABLE_CURATES . ' AS u2g ON (u.id = u2g.userid) WHERE u2g.geneid = ? AND u2g.allow_edit = 1 ORDER BY u.level DESC, u.name', array($sCurrSymbol));
    $nCurators = mysql_num_rows($qCurators);
    $i = 0;
    while ($z = mysql_fetch_assoc($qCurators)) {
        $i ++;
        $sCurators .= ($sCurators? ($i == $nCurators? ' and ' : ', ') : '') . '<A href="mailto:' . str_replace(array("\r\n", "\r", "\n"), ', ', trim($z['email'])) . '">' . $z['name'] . '</A>';
    }

    if ($sCurators) {
        print('  <TR>' . "\n" .
              '    <TD width="150">&nbsp;</TD>' . "\n" .
              '    <TD valign="top" colspan="2" style="padding-bottom : 2px;"><B>' . ($nCurators > 1 ? 'Curators: ' : 'Curator: ') . $sCurators . '</B></TD>' . "\n" .
              '  </TR>' . "\n");
    }
}

print('</TABLE>' . "\n\n");



// Build menu tabs...
print('<TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="logo">' . "\n" .
      '  <TR>' . "\n" .
      '    <TD align="left" style="background : url(\'gfx/tab_fill.png\'); background-repeat : repeat-x;">' . "\n");

// Loop menu.
$n         = 0;
$bSel      = false;
$bPrevSel  = false;
foreach ($_MENU as $sPrefix => $sTitle) {
    // Array (children links of parent tabs) are not processed here.
    if (is_array($sTitle)) {
        continue;
    }

    // Determine if we're the current tab.
    $bSel = (substr(lovd_getProjectFile(), 1, strrpos(lovd_getProjectFile(), '.') - 1) == $sPrefix);
    // Auch! Hard coded exception!
    if (!$bSel && $sPrefix == 'docs' && substr(lovd_getProjectFile(), 0, 6) == '/docs/') { $bSel = true; }
    $sFileName = 'tab_' . $sPrefix;

    // Print transition.
    print('      <IMG src="gfx/tab_' . (!$n? '0' : ($bPrevSel? 'F' : 'B')) . ($bSel? 'F' : 'B') . '.png" alt="" width="25" height="25" align="left">' . "\n");

    // Get header info.
    $sFileName = 'gfx/' . $sFileName . '_' . ($bSel? 'F' : 'B') . '.png';
    $aImage = @getimagesize($sFileName);
    $sSize = $aImage[3];

    // Print header.
    print('      <A href="' . $sPrefix . '"><IMG src="' . $sFileName . '" alt="' . $sTitle . '" title="' . $sTitle . '" ' . $sSize . ' align="left"></A>' . "\n");

    $bPrevSel = $bSel;
    $n ++;
}

// Closing transition.
print('      <IMG src="gfx/tab_' . ($bPrevSel? 'F' : 'B') . '0.png" alt="" width="25" height="25" align="left">' . "\n");

print('    </TD>' . "\n" .
      '  </TR>' . "\n" .
      '</TABLE>' . "\n\n");
?>



<DIV style="padding : 0px 10px;">
<TABLE border="0" cellpadding="0" cellspacing="0" width="100%">
  <TR>
    <TD style="padding-top : 10px;">







