<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2009-10-22
 * Modified    : 2012-06-19
 * For LOVD    : 3.0-beta-06
 *
 * Copyright   : 2004-2012 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *               Ing. Ivar C. Lugtenburg <I.C.Lugtenburg@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************/

$aColSQL =
         array(
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Age_of_death",            248, 100, 0, 0, 0, "Age of death",         "Type 35y for 35 years, 04y08m for 4 years and 8 months, 18y? for around 18 years, >54y for still alive at 55, ? for unknown.", "The age at which the individual deceased, if known and applicable. 04y08m = 4 years and 8 months.", "The age at which the individual deceased, if known and applicable.\r\n<UL style=\"margin-top:0px;\">\r\n  <LI>35y = 35 years</LI>\r\n  <LI>04y08m = 4 years and 8 months</LI>\r\n  <LI>18y? = around 18 years</LI>\r\n  <LI>&gt;54y = still alive at 55</LI>\r\n  <LI>? = unknown</LI>\r\n</UL>", "VARCHAR(12)", "Age of death|The age at which the individual deceased, if known and applicable. Numbers lower than 10 should be prefixed by a zero and the field should always begin with years, to facilitate sorting on this column.|text|10", "", "/^([<>]?\\\\d{2,3}y(\\\\d{2}m(\\\\d{2}d)?)?)?\\\\??$/", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Consanguinity",           240,  40, 0, 0, 0, "Consanguinity",        "Indicates whether the parents are related (consanguineous), not related (non-consanguineous) or whether consanguinity is not known (unknown)", "Indicates whether the parents are related (consanguineous), not related (non-consanguineous) or whether consanguinity is not known (unknown)", "Indicates whether the parents are related (consanguineous), not related (non-consanguineous) or whether consanguinity is not known (unknown)", "VARCHAR(5)", "Consanguinity||select|1|--Not specified--|false|false", "? = Unknown\r\nno = Non-consanguineous parents\r\nyes = Consanguineous parents", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Death/Cause",             249, 150, 0, 0, 0, "Cause of death",       "", "The cause of the individual\'s death, if known and applicable.", "The cause of the individual\'s death, if known and applicable.", "VARCHAR(255)", "Cause of death|The cause of the individual\'s death, if known and applicable.|text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                // SEER list: 1 Male, 2 Female, 3 Other (hermaphrodite, sex chromosome abberations), 4 Transsexual/Transgender, 9 Not stated/Unknown
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Gender",                    3,  70, 0, 0, 0, "Gender",               "", "Individual\'s gender.", "The gender of the reported individual.", "VARCHAR(7)", "Gender||select|1|--Not specified--|false|false", "Female\r\nMale\r\nUnknown", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Lab_ID",                    1,  80, 1, 1, 1, "Lab\'s ID",            "", "The ID given to this individual by its reference.", "The ID given to this individual by its reference, such as a hospital, diagnostic laboratory or a paper.", "VARCHAR(15)", "Lab ID||text|10", "", "", 0, 1, 0, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Reference",                 2, 200, 1, 1, 0, "Reference",            "", "Reference describing the individual.", "Literature reference with possible link to publication in PubMed or other online resource. References in the &quot;Country:City&quot; format indicate that the mutation was submitted directly to this database by the laboratory indicated.", "VARCHAR(200)", "Reference||text|50", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Remarks",                 250, 200, 0, 1, 0, "Remarks",              "", "Optional remarks about the individual.", "Optional remarks about the individual, that does not belong in any of the other fields.", "TEXT", "Remarks||textarea|50|3", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Remarks_Non_Public",      251, 200, 0, 1, 0, "Remarks (non public)", "", "Optional non-public remarks about the individual.", "Optional non-public remarks about the individual, that does not belong in any of the other fields.", "TEXT", "Remarks (non public)||textarea|50|3", "", "", 0, 0, 0, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Origin/Geographic",       200, 200, 0, 0, 0, "Geographic origin",    "", "Geographic origin of individual.", "The geographic origin of the individual (country and/or region).", "VARCHAR(50)", "Geographic origin||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Origin/Ethnic",           201, 200, 0, 0, 0, "Ethnic origin",        "", "Ethnic origin of individual.", "The ethnic origin of the individual (race).", "VARCHAR(50)", "Ethnic origin|If mixed, please indicate origin of father and mother, if known.|text|20", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Origin/Population",       202, 200, 0, 0, 0, "Population",           "", "Individual population.", "Additional information on the individual\'s population.", "VARCHAR(50)", "Individual population||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Phenotype/Age",                        2, 100, 0, 0, 0, "Age examined",         "Type 35y for 35 years, 04y08m for 4 years and 8 months, 18y? for around 18 years, >54y for older than 54, ? for unknown.", "The age at which the individual was examined, if known. 04y08m = 4 years and 8 months.", "The age at which the individual was examined, if known.\r\n<UL style=\"margin-top:0px;\">\r\n  <LI>35y = 35 years</LI>\r\n  <LI>04y08m = 4 years and 8 months</LI>\r\n  <LI>18y? = around 18 years</LI>\r\n  <LI>&gt;54y = older than 54</LI>\r\n  <LI>? = unknown</LI>\r\n</UL>", "VARCHAR(12)", "Age at examination|The age at which the individual was examined, if known. Numbers lower than 10 should be prefixed by a zero and the field should always begin with years, to facilitate sorting on this column.|text|10", "", "/^([<>]?\\\\d{2,3}y(\\\\d{2}m(\\\\d{2}d)?)?)?\\\\??$/", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Phenotype/Date",                       1,  80, 0, 0, 0, "Date",                 "Format: YYYY-MM-DD.", "Date the phenotype was observed.", "Date the phenotype was observed, in YYYY-MM-DD format.", "DATE", "Date||text|10", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Phenotype/Inheritance",              254, 200, 0, 0, 0, "Inheritance",          "Indicates the inheritance of the phenotype in the family; unknown, familial (autosomal/X-linked, dominant/ recessive), paternal (Y-linked), maternal (mitochondrial) or isolated (sporadic)", "Indicates the inheritance of the phenotype in the family; unknown, familial (autosomal/X-linked, dominant/ recessive), paternal (Y-linked), maternal (mitochondrial) or isolated (sporadic)", "Indicates the inheritance of the phenotype in the family; unknown, familial (autosomal/X-linked, dominant/ recessive), paternal (Y-linked), maternal (mitochondrial) or isolated (sporadic)", "VARCHAR(50)", "Inheritance||select|1|--Not specified--|false|false", "Unknown\r\nFamilial\r\nFamilial, autosomal dominant\r\nFamilial, autosomal recessive\r\nFamilial, X-linked dominant\r\nFamilial, X-linked dominant, male sparing\r\nFamilial, X-linked recessive\r\nPaternal, Y-linked\r\nMaternal, mitochondrial\r\nIsolated (sporadic)", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Phenotype/Length",                   200, 100, 0, 0, 0, "Length",               "", "Length of the individual, in cm.", "Length of the individual, in centimeters (cm).", "SMALLINT(3) UNSIGNED", "Length of individual (cm)|Length of individual, in centimeters.|text|3", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Screening/Date",                       1,  80, 0, 0, 0, "Date",                 "Format: YYYY-MM-DD.", "Date the detection technique was performed.", "Date the detection technique was performed, in YYYY-MM-DD format.", "DATE", "Date||text|10", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Screening/Technique",                  3, 200, 1, 1, 1, "Technique",            "", "Technique used to detect variants.", "Technique used to reveal the variants that are reported.", "VARCHAR(150)", "Technique(s) used||select|5|false|true|false", "Unknown\r\nBESS = Base Excision Sequence Scanning\r\nCMC = Chemical Mismatch Cleavage\r\nCSCE = Conformation sensitive capillary electrophoresis\r\nDGGE = Denaturing-Gradient Gel-Electrophoresis\r\nDHPLC = Denaturing High-Performance Liquid Chromatography\r\nDOVAM = Detection Of Virtually All Mutations (SSCA variant)\r\nDSCA = Double-Strand DNA Conformation Analysis\r\nHD = HeteroDuplex analysis\r\nIHC = Immuno-Histo-Chemistry\r\nmPCR = multiplex PCR\r\nMAPH = Multiplex Amplifiable Probe Hybridisation\r\nMLPA = Multiplex Ligation-dependent Probe Amplification\r\nNGS = Next Generation Sequencing\r\nPAGE = Poly-Acrylamide Gel-Electrophoresis\r\nPCR = Polymerase Chain Reaction\r\nPTT = Protein Truncation Test\r\nRT-PCR = Reverse Transcription and PCR\r\nSEQ = SEQuencing\r\nSouthern = Southern Blotting\r\nSSCA = Single-Strand DNA Conformation Analysis (SSCP)\r\nWestern = Western Blotting", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Screening/Template",                   2,  80, 1, 1, 1, "Template",             "", "Screening performed on DNA, RNA and/or Protein level.", "Screening performed on DNA, RNA and/or Protein level.", "VARCHAR(20)", "Detection template||select|3|false|true|false", "DNA\r\nRNA\r\nProtein", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Screening/Tissue",                     4, 100, 0, 0, 1, "Tissue",               "", "Tissue type used for the detection of sequence variants.", "Tissue type used for the detection of sequence variants.", "VARCHAR(25)", "Tissue||text|20", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Conservation_score/GERP", 4, 100, 0, 0, 0, "GERP conservation",    "", "Conservation score as calculated by GERP.", "The Conservation score as calculated by GERP.", "DECIMAL(5,3)", "GERP conservation score||text|6", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/DBID",                 7,  80, 1, 1, 1, "DB-ID",                "NOTE: This field will be predicted and filled in by LOVD, if left empty.", "DataBase IDentifier.", "DataBase IDentifier, grouping multiple instances of the same variant together.", "VARCHAR(50)", "ID|This ID is used to group multiple instances of the same variant together. The ID starts with the gene symbol of the transcript most influenced by the variant or otherwise the closest gene, followed by an underscore (_) and the 6 digit ID code.|text|20", "", "/^(chr(\\\\d{1,2}|[XYM])|(C(\\\\d{1,2}|[XYM])orf\\\\d+-|[A-Z][A-Z0-9]+-)?(C(\\\\d{1,2}|[XYM])orf\\\\d+|[A-Z][A-Z0-9]+))_\\\\d{6}$/", 1, 0, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/dbSNP",                8, 120, 0, 0, 0, "dbSNP ID",             "", "The dbSNP ID.", "The dbSNP ID.", "VARCHAR(15)", "dbSNP ID|If available, please fill in the dbSNP ID, such as rs12345678.|text|10", "", "/^[rs]s\\\\d+$/", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/DNA",                  2, 200, 1, 1, 1, "DNA change (genomic)", "", "Variation at genomic DNA level.", "Variation at genomic DNA level.", "VARCHAR(100)", "Genomic DNA change (HGVS format)||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Genetic_origin",      11, 200, 0, 0, 0, "Genetic origin",       "Origin of variant; unknown, germline (i.e. inherited), somatic, de novo, from parental disomy (maternal or paternal) or in vitro (cloned)", "Origin of variant; unknown, germline (i.e. inherited), somatic, de novo, from parental disomy (maternal or paternal) or in vitro (cloned)", "Origin of variant; unknown, germline (i.e. inherited), somatic, de novo, from parental disomy (maternal or paternal) or in vitro (cloned)", "VARCHAR(40)", "Genetic origin||select|1|--Not specified--|false|false", "Unknown\r\nGermline (inherited)\r\nSomatic\r\nDe novo\r\nUniparental disomy\r\nUniparental disomy, maternal allele\r\nUniparental disomy, paternal allele", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Published_as",         3, 200, 0, 0, 0, "Published as",         "What the variant was reported as (e.g. 521delT); listed only when different from \"DNA change\".", "What the variant was reported as.", "What the variant was reported as (e.g. 521delT); listed only when different from \"DNA change\".", "VARCHAR(100)", "Published as||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Frequency",            9,  90, 0, 1, 0, "Frequency",            "", "Frequency if variant is non pathogenic.", "Frequency of non pathogenic variant reported listed as number of variant alleles/number of control alleles tested, like 5/132.", "VARCHAR(15)", "Frequency||text|10", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Reference",            6, 200, 1, 1, 0, "Reference",            "", "Reference describing the variant.", "Literature reference with possible link to publication in PubMed, dbSNP, OMIM entry or other online resource.", "VARCHAR(255)", "Reference||text|50", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                // Add remarks non public? Add remarks column(s) to VariantOnTranscript???
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Remarks",             10, 200, 0, 0, 0, "Variant remarks",      "", "Variant remarks", "Variant remarks", "TEXT", "Remarks||textarea|50|3", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                // FIXME: Increase to VARCHAR(25)?
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Restriction_site",     5,  75, 0, 1, 0, "Re-site",              "", "Variant creates (+) or destroys (-) a restriction enzyme recognition site.", "Variant creates (+) or destroys (-) a restriction enzyme recognition site.", "VARCHAR(15)", "Re-site||text|10", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Segregation",         12,  40, 0, 0, 0, "Segregation",          "Indicates whether the variant segregates with the disease (yes), does not segregate with the disease (no) or segregation is unknown (?)", "Indicates whether the variant segregates with the disease (yes), does not segregate with the disease (no) or segregation is unknown (?)", "Indicates whether the variant segregates with the disease (yes), does not segregate with the disease (no) or segregation is unknown (?)", "VARCHAR(5)", "Segregation||select|1|--Not specified--|false|false", "? = Unknown\r\nyes = Segregates with disease\r\nno = Does not segregate with disease", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                // FIXME; link this one to an ontology?
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Type",                 1, 200, 0, 0, 1, "Type",                 "", "Type of variant at DNA level.", "Type of variant at DNA level.", "VARCHAR(20)", "Type of variant (DNA level)||select|1|false|false|false", "Substitution\r\nDeletion\r\nDuplication\r\nInsertion\r\nInversion\r\nInsertion/Deletion\r\nTranslocation\r\nOther/Complex", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Distance_to_splice_site", 10, 150, 0, 0, 0, "Splice distance",      "", "The distance to the nearest splice site.", "The distance to the nearest splice site.", "MEDIUMINT(8) UNSIGNED", "Distance to splice site||text|8", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/DNA",              3, 200, 1, 1, 1, "DNA change (cDNA)",    "", "Variation at DNA-level.", "Variation at DNA level.", "VARCHAR(100)", "DNA change (HGVS format)||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Published_as",     4, 200, 0, 0, 0, "Published as",         "What the variant was reported as (e.g. 521delT); listed only when different from \"DNA change\".", "What the variant was reported as.", "What the variant was reported as (e.g. 521delT); listed only when different from \"DNA change\".", "VARCHAR(100)", "Published as||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Exon",             2,  50, 0, 1, 1, "Exon",                 "", "Exon numbering.", "Exon numbering.", "VARCHAR(5)", "Exon|Format: use \"03\" for exon 3, \"03i\" for intron 3, or \"03_05\" for a deletion of exons 3 to 5.|text|5", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/GVS/Function",     9, 200, 0, 0, 0, "GVS function",         "", "Functional annotation of this position by GVS.", "The functional annotation of this position from the Genome Variation Server.", "VARCHAR(30)", "GVS function|Whether the variant is missense, nonsense, in an intron, UTR, etc.|text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Location",         1, 200, 0, 0, 1, "Location",             "", "Variant location at DNA level.", "Location of the DNA variant in the transcript.", "VARCHAR(16)", "Location||select|1|true|false|false", "5\' Gene flanking\r\n5\' UTR\r\nExon\r\nIntron\r\n3\' UTR\r\n3\' Gene flanking", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/PolyPhen",         8, 200, 0, 0, 0, "PolyPhen prediction",  "", "The effect predicted by PolyPhen.", "The effect predicted by PolyPhen.", "VARCHAR(20)", "PolyPhen prediction||select|1|true|false|false", "benign = Benign\r\npossiblyDamaging = Possibly damaging\r\nprobablyDamaging = Probably damaging\r\nnoPrediction = No prediction", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Position",         5, 100, 0, 0, 0, "Position",             "", "Position in cDNA sequence.", "The position of this variant in the cDNA sequence.", "MEDIUMINT(5)", "cDNA Position||text|5", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Protein",          7, 200, 1, 1, 1, "Protein",              "", "Variation at protein level.", "Predicted effect of change on protein (usually without experimental proof!)<BR>\r\n<UL style=\"margin-top : 0px;\">\r\n  <LI>p.Arg345Pro = RNA-predicted protein change</LI>\r\n  <LI>p.(Arg345Pro) = DNA-predicted protein change (RNA not analysed)</LI>\r\n  <LI>p.(del) = DNA predicted in-frame deletion in protein (RNA not analysed)</LI>\r\n  <LI>p.(fsX) = DNA-predicted frame shifting deletion in protein (RNA not analysed)</LI>\r\n  <LI>p.(?) = protein change unknown</LI>\r\n  <LI>p.(0) = change expected to abolish translation</LI>\r\n</UL>", "VARCHAR(100)", "Protein change (HGVS format)||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/RNA",              6, 200, 1, 1, 1, "RNA change",           "", "Variation at RNA level.", "Effect of change on RNA.<BR>\r\n<UL style=\"margin-top : 0px;\">\r\n  <LI>r.123c>u</LI>\r\n  <LI>r.? = unknown</LI>\r\n  <LI>r.(?) = RNA not analysed but probably directly transcribed copy of DNA variant</LI>\r\n  <LI>r.spl? = RNA not analysed but variant probably affects splicing</LI>\r\n  <LI>r.stab = RNA stability affected (no altered splice product detected)</LI>\r\n  <LI>r.(0) = change expected to abolish transcription</LI>\r\n</UL>", "VARCHAR(100)", "RNA change (HGVS format)||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
              );
?>
